<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Application;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\ListingController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\PackagesController;
use App\Http\Controllers\SiteInfoController;
use App\Http\Controllers\AppSettingsController;




Route::controller(AdminController::class)->group(function () {
    Route::get('admin', 'index')->middleware('admin')->name('admin_check');
    Route::get('admin/dashboard', 'index')->middleware('admin')->name('dashboard');
    Route::get('admin/login', 'login')->middleware(['admin_check', 'guest'])->name('admin/login');
    Route::get('admin/password-settings', 'password_settings')->middleware('admin')->name('password-settings');
    Route::post('change-password', 'change_password')->middleware('admin')->name('change-password');

    Route::post('image-upload', 'image_upload')->middleware('auth')->name('image-upload');
});

Route::controller(SiteInfoController::class)->group(function () {
    Route::post('upload-site-logo', 'upload_site_logo')->middleware('admin')->name('upload-site-logo');
    Route::post('upload-fav-icon', 'upload_fav_icon')->middleware('admin')->name('upload-fav-icon');
    Route::post('update-about', 'update_about')->middleware('admin')->name('update-about');
    Route::post('update-contact-details', 'update_contact_details')->middleware('admin')->name('update-contact-details');
    Route::post('update-social-links', 'update_social_links')->middleware('admin')->name('update-social-links');
   
});



Route::controller(UserController::class)->group(function () {
    Route::get('admin/view-users', 'viewUsers')->middleware('admin')->name('admin/view-users');
    Route::delete('remove-user/{id}', 'removeUser')->middleware('auth')->name('remove-user');
    Route::get('admin/view-trashed-users', 'userTrash')->middleware('admin')->name('admin/view-trashed-users');
    Route::delete('restore-user/{id}', 'restoreUser')->middleware('auth')->name('restore-user');
});

Route::resource('listing', ListingController::class)->middleware(['auth', 'is_verified']);
Route::controller(ListingController::class)->group(function () {
    Route::get('admin/view-all-listing', 'viewAllListings')->middleware(['auth', 'admin'])->name('admin/view-all-listing');
    Route::get('admin/view-trash-listing', 'viewTrashListings')->middleware(['auth', 'admin'])->name('admin/view-trash-listing');
    Route::put('update-listing-featured', 'update_listing_featured')->middleware('admin')->name('update-listing-featured');
    Route::delete('restore-listing/{id}', 'restoreListing')->middleware( 'admin')->name('restore-listing');
    Route::get('admin/bulk-import', 'bulkImport')->middleware(['auth', 'admin'])->name('admin/bulk-import');
});


Route::resource('admin/category', CategoryController::class)->middleware('admin');
Route::put('update-category-featured', [CategoryController::class, 'update_category_featured'])->middleware('admin')->name('update-category-featured');

Route::resource('admin/pages', PageController::class)->middleware('admin');

Route::resource('admin/app-settings', AppSettingsController::class)->middleware('admin');
Route::resource('admin/siteinfo', SiteInfoController::class)->middleware('admin');

