<?php

namespace App\Http\Controllers\Helper;

use App\Models\Blog;
use App\Models\Page;
use App\Models\Listing;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\Helper\SitemapService;

class SiteMapController extends Controller
{

    public function __construct()
    {

        header("Content-Type: application/xml; charset=utf-8"); 
        echo '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL; 		
        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">' .PHP_EOL; 
    }

    public function index()
    {
        $sms = new SitemapService();
        $this->siteInfo($sms);
        $this->category($sms);
        $this->listing($sms);
        $this->blog($sms);
        $this->page($sms);
        echo $sms->getSitemap();
        echo '</urlset>';	
    }

    public function siteInfo($sms){
        $sms->addSitemap(route('/'));
        $sms->addSitemap(route('all-cities'), '.7');
        $sms->addSitemap(route('all-categories'), '.7');
        $sms->addSitemap(route('all-listings'), '.7');
        $sms->addSitemap(route('view-blogs'), '.7');
    }

    public function category($sms)
    {
        $category = Category::get();
        $category->map(function($c) use ($sms){
            $sms->addSitemap(route('cat', $c->url), '.9');
        });
    }

    public function listing($sms)
    {
        $listing = Listing::get();
        $listing->map(function($l) use ($sms){
            $sms->addSitemap(route('view', $l->url), '.9');
        });
    }

    public function blog($sms)
    {
        $category = Category::get();
        $category->map(function($c) use ($sms){
            $sms->addSitemap(route('blog-by-cat', $c->url), '.8');
        });

        $blogs = Blog::get();
        $blogs->map(function($b) use ($sms){
            $sms->addSitemap(route('single-blogs', $b->url), '.8');
        });
    }

    public function page($sms)
    {
        $pages = Page::get();
        $pages->map(function($p) use ($sms){
            $sms->addSitemap(route('page', $p->url), '.8');
        });
    }
}
