{capture name="title"} - {l}Submit Category{/l}{/capture}
{capture assign="in_page_title"}{l}Submit Category{/l}{/capture}
{capture assign="description"}{l}Submit a new category to the directory{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}

{include file="validation.tpl" form_id="submit_form" validators=$validators}

{literal}
<script type="text/javascript">
jQuery(document).ready(function(){
    jQuery('#PARENT_ID').change(function() {
        valid_obj.submit_form.rules.TITLE.remote.data.PARENT_ID = jQuery('#PARENT_ID').val();
    });
});

</script>
{/literal}

{strip}

{if $smarty.const.DISABLE_SUBMIT == 1 && $is_admin neq 1} 
<table width="96%" border="0" align="center" cellpadding="4" cellspacing="4" class="sp_area">   
 <tr>      
  <td>         
    <h2>{l}Closed{/l}</h2>      
  </td>   
 </tr>   
 <tr>      
    <td>         
     {l}We are sorry but category submissions are closed.{/l}<br />         {$disablereason}</a>      
     </td>   
 </tr> 
</table> 
<br /> 
{else}

{if empty($regular_user_details.ID) || (($uLevel != 1) && ($uLevel != 3))}
    <table border="0" class="formPage">
       <tr>
          <td>
             <h3>{l}Information{/l}</h3>
          </td>
       </tr>
       <tr>
          <td>
             {l}You must be logged in as Admin or Super Editor to submit a new category.{/l}
             <br />
             {l}No account yet?{/l} <a href="{$smarty.const.DOC_ROOT}/profile.php?mode=register" title="{l}Register new user{/l}">{l}Create one{/l}</a>
          </td>
       </tr>
    </table>
{else}
    <form method="post" action="" id="submit_form">
    <table border="0" class="formPage">
    {if $error}
       <tr><td colspan="2" class="err">
          {l}An error occured while saving the category.{/l}
       </td></tr>
    {/if}
    
    {if $posted}
       <tr><td colspan="2" class="msg">
       {l}Category submitted{/l}{if $waiting_approval eq 1}{l} and awaiting approval{/l}{/if}.<br />
       {l}Submit another category.{/l}
       </td></tr>
    {/if}

<tr>
   <td class="label underlined" align='left' colspan="2">{l}Fields marked with a {/l}<span class='req'>*</span>{l} are required.{/l}</td>
   </tr>
  <tr>
   <td class="label"><span class='req'>*</span>{l}Title{/l}:</td>
   <td class="field">
      <input type="text" name="TITLE" value="{$TITLE|escape|trim}" size="40" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" />
   </td>
  </tr>
  
  {if $ENABLE_REWRITE and $symbolic ne 1}
  <tr>
     <td class="label"><span class='req'>*</span>{l}URL Title{/l}:</td>
     <td class="field">
        <input type="text" id="TITLE_URL" name="TITLE_URL" size="40" value="{$TITLE_URL|escape|trim}" maxlength="255" class="text" />
     </td>
  </tr>
  {/if}
  {if $symbolic ne 1}
  <tr>
    <td class="label">{l}Description{/l}:</td>
    <td class="field">
     <textarea name="DESCRIPTION" rows="3" cols="37" class="text" {formtool_count_chars name="DESCRIPTION" limit=$smarty.const.DESCRIPTION_MAX_LENGTH alert=true}>{$DESCRIPTION|escape|trim}</textarea>
        <br />
        {l}Limit{/l}: <input type="text" name="DESCRIPTION_limit" size="4" class="limit_field" readonly="readonly" value="{$DescriptionLimit|trim}" />{if isset ($allowedTags)} <small>Allowed html tags: {$allowedTags|wordwrap:30:"<br />\n"}</small>{/if} <br />{if isset ($allowedAttr)}<small>Allowed html attribute tags: {$allowedAttr|wordwrap:30:"<br />\n"}</small>{/if}
    </td>
  </tr>
  {/if}
  <tr>
   <td class="label">{l}Parent Category{/l}:</td>
   <td class="field">
      {* Load category selection *}
      {include file="category_select_parent.tpl"}
   </td>
 </tr>
 <tr>
   <td class="label">{l}RSS feed:{/l}</label></td>
   <td class="field">
       <input type="text" id="RSS_URL" name="RSS_URL" value="{$RSS_URL|escape|trim}" maxlength="255" size="40" class="text" />
   </td>
 </tr>
 
 {if $symbolic eq 1}
 <tr>
    <td class="label required"><label for="SYMBOLIC_ID">{l}Symbolic category for{/l}:</label></td>
    <td class="smallDesc">
       {html_options options=$categs selected=$SYMBOLIC_ID name="SYMBOLIC_ID" id="SYMBOLIC_ID"}
    </td>
 </tr>
 {/if}

 <tr>
    <td class="label required"><label for="STATUS">{l}Status{/l}:</label></td>
    <td class="smallDesc">
        {html_options options=$stats selected=$STATUS name="STATUS" id="STATUS"}
    </td>
 </tr>
  
 {if $symbolic ne 1 and $smarty.const.ENABLE_META_TAGS eq 1}
   <tr>
      <td class="label">{l}META Keywords{/l}:</td>
      <td class="field">
        <input type="text" name="META_KEYWORDS" value="{$META_KEYWORDS|escape|trim}" size="40" maxlength="2000" class="text" />
        <p class="small">{l}Separate keywords by comma.{/l}</p>
      </td>
   </tr>
   <tr>
      <td class="label">{l}META Description{/l}:</td>
      <td class="field">
         <textarea name="META_DESCRIPTION" rows="3" cols="30" class="text" {formtool_count_chars name="META_DESCRIPTION" limit=$smarty.const.META_DESCRIPTION_MAX_LENGTH alert=true}>{$META_DESCRIPTION|escape|trim}</textarea>
         <br />
         {l}Limit{/l}: <input type="text" name="META_DESCRIPTION_limit" size="4" class="limit_field" readonly="readonly" value="{$MetaDescriptionLimit|trim}" />
      </td>
   </tr>
  {/if}

  {if $symbolic ne 1}
  <tr>
  <td class="label">{l}Page Title{/l}:</td>
  <td class="field">
  <textarea name="TDESCRIPTION" id="TDESCRIPTION" rows="6" cols="37" class="text" >{$TDESCRIPTION|trim|escape}</textarea>
  </td>
  </tr>
  {/if} 
  
  {if $symbolic ne 1}
  <tr>
  <td class="label">{l}Main area Content for the Category{/l}:</td>
  <td class="field">
    {include file="rte.tpl" NAME="CATCONTENT" VALUE=$CATCONTENT}
  </td>
  </tr>
  {/if}
  
  <tr>
      <td colspan="2" class="buttons">
         {if !$review_cat and !$remove_cat}
            <input type="submit" name="continue" value="{l}Continue{/l}" class="btn" />
         {else}
            <input type="submit" name="edit" value="{l}Continue{/l}" class="btn" />
         {/if}
      </td>
  </tr>
</table>
<input type="hidden" name="formSubmitted" value="1" />
</form>
{/if}
{/if}
{include file="footer.tpl"}
{/strip}