{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/validation.tpl" form_id="edit_link_form" validators=$validators}

{* Error and confirmation messages *}
{include file="messages.tpl"}

{strip}
{if (isset($error) and $error gt 0) or !empty($sql_error)}
   <div class="error block">
      <h2>{l}Error{/l}</h2>
      <p>{l}An error occured while saving.{/l}</p>
      {if !empty($errorMsg)}
         <p>{$errorMsg|escape}</p>
      {/if}
      {if !empty($sql_error)}
         <p>{l}The database server returned the following message:{/l}</p>
         <p>{$sql_error|escape}</p>
      {/if}
   </div>
{/if}

{if $posted}
   <div class="success block">
      {l}Link saved.{/l}
   </div>
{/if}

{if isset($AllowedFeat) and $AllowedFeat ne 1}
   <div class="error block">
      <p>{l}Maximum number of featured links for this category exceeded!{/l}</p>
      <p>{l}Please review link preferences.{/l}</p>
   </div>
{/if}

<div class="block">
   <form method="post" action="" id="edit_link_form" onSubmit="return false;">
   <table class="formPage">

   {if isset($action) and ($action eq 'N' or $action eq 'E')}
   <thead>
      <tr>
         <th colspan="2">
            {if $action eq 'N'}
               {l}Link review{/l}
            {elseif $action eq 'E'}
               {l}Link review{/l}
            {/if}
         </th>
      </tr>
  </thead>
  {/if}

   <tbody>
      {if $submit_items}
	<div id="add_items">
		<table class="formPage">
			{foreach from=$submit_items item=item name=submit_items}
			{* special submit items *}
			{if $item.FIELD_NAME == 'TITLE'}
				<tr>
					<td class="label required"><label for="TITLE">{l}Title{/l}:</label></td>
					<td class="smallDesc">
						<input type="text" id="TITLE" name="TITLE" value="{$data.TITLE|escape|trim}" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" disabled="true"/>
	            		{if $SEO_URL != ''}
	            			<a class="admin_action" href="{if !$smarty.const.ENABLE_REWRITE}
	                                                {$smarty.const.DOC_ROOT}/detail.php?id={$ID}
	                                             {else}
	                                                {$smarty.const.DOC_ROOT}/{$SEO_URL}{/if}" title="{l}Preview Link on the Front End{/l}" target="_blank">
	            				<img src="{$smarty.const.TEMPLATE_ROOT}/images/outbox.png"/>
	            			</a>
	            		{/if}
	         		</td>
	      		</tr>
			{elseif $item.FIELD_NAME == 'CATEGORY_ID'}
				<tr>
					<td class="label required"><label for="CATEGORY_ID">{l}Category{/l}:</label></td>
					<td class="smallDesc">
						{* Load category selection *}
						{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/admin_category_select.tpl" selected=$data.CATEGORY_ID  selected_parent=$data.PARENT_ID}
						{if $link_type_details.MULTIPLE_CATEGORIES != ''}
							{foreach from=$add_categs item=categ}
								<div>
									{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/admin_category_select.tpl" categ_id=$categ.CATEGORY_ID additional_categs=true}&nbsp;
									<a href="#" onclick="removeCateg(this); return false;">{l}remove{/l}</a>
									<div style="float: none; clear: both; height: 8px;"></div>
								</div>
							{/foreach}
						{/if}
						<div id="categ" style="display: none;">
							<br />
							{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/admin_category_select.tpl" additional_categs=true}&nbsp;
						</div>
						{* editing disabled here
						<a href="" class="formDelCateg" id="fileDelCateg" onclick="removeCateg(this); return false;" style="display: none">{l}remove{/l}</a>
  						<div class="clear"></div>
  						<br />
	   					<a onclick="plusCateg();return false;" href="" id="plusCategLink" class="formSmall" style="border-width: 0;">+ {l}additional categ{/l}</a>
	   					*}
					</td>
      			</tr>
			{elseif $item.FIELD_NAME == 'OWNER_NAME'}
				<tr>
					<td class="label"><label for="OWNER_NAME">{l}Owner Name{/l}:</label></td>
					<td class="smallDesc">
						<input type="text" id="OWNER_NAME" disabled="true" name="OWNER_NAME" value="{$data.OWNER_NAME|escape|trim}" maxlength="{$smarty.const.USER_NAME_MAX_LENGTH}" class="text" />
					</td>
				</tr>
			{elseif $item.FIELD_NAME == 'OWNER_EMAIL'}
				<tr>
					<td class="label"><label for="OWNER_EMAIL">{l}Owner Email{/l}:</label></td>
					<td class="smallDesc">
						<input type="text" disabled="true" id="OWNER_EMAIL" name="OWNER_EMAIL" value="{$data.OWNER_EMAIL|escape|trim}" maxlength="255" class="text" />
					</td>
				</tr>
			{elseif $item.FIELD_NAME == 'META_KEYWORDS'}
				{if $smarty.const.ENABLE_META_TAGS eq 1}
				<tr class="thead">
					<th colspan="2">{l}META tags{/l}</th>
				</tr>
				<tr class="thead">
					<td colspan="2" class="info notice">{l}Define custom META tags for detail pages. Leave blank to use default tags defined for your directory.{/l}</td>
				</tr>
				<tr>
					<td class="label"><label for="META_KEYWORDS">{l}META Keywords{/l}:</label></td>
					<td class="smallDesc">
						<input type="text" disabled="true" id="META_KEYWORDS" name="META_KEYWORDS" value="{$data.META_KEYWORDS|escape|trim}" class="text" />
						<p class="msg notice info">{l}Separate keywords by comma.{/l}</p>
					</td>
				</tr>
				{/if}
			{elseif $item.FIELD_NAME == 'META_DESCRIPTION'}
				{if $smarty.const.ENABLE_META_TAGS eq 1}
				<tr>
					<td class="label"><label for="META_DESCRIPTION">{l}META Description{/l}:</label></td>
					<td class="smallDesc">
						<textarea id="META_DESCRIPTION" disabled="true" name="META_DESCRIPTION" rows="3" cols="30" class="text" {formtool_count_chars name="META_DESCRIPTION" limit=$smarty.const.META_DESCRIPTION_MAX_LENGTH alert=true}>{$data.META_DESCRIPTION|trim|escape}</textarea>
						<p class="limitDesc">{l}Limit{/l}: <input type="text" name="META_DESCRIPTION_limit" class="limit_field" readonly="readonly" value="{$MetaDescriptionLimit}" /></p>
					</td>
				</tr>
				{/if}
			{* /special submit items *}
			{else}
				<tr>
				   	<td class="label"><label for="{$item.FIELD_NAME}">{l}{$item.NAME}{/l}:</label></td>
				   	<td class="smallDesc">
						{if $item.TYPE eq 'STR'}
							<input type="text" disabled="true" name="{$item.FIELD_NAME}" id="{$item.FIELD_NAME}" value="{$data[$item.FIELD_NAME]|escape|trim}" size="40" class="text" />
						{elseif $item.TYPE eq 'TXT'}
						    {include file=$smarty.const.ADMIN_TEMPLATE|cat:"/rte.tpl" NAME=$item.FIELD_NAME VALUE=$data[$item.FIELD_NAME]|escape|trim}

						{elseif $item.TYPE eq 'BOOL'}
							{html_options options=$yes_no selected=$data[$item.FIELD_NAME] name=$item.FIELD_NAME id=$item.FIELD_NAME}
						{elseif $item.TYPE eq 'CAT'}
							{html_options options=$categs selected=$data[$item.FIELD_NAME] name=$item.FIELD_NAME id=$item.FIELD_NAME}
						{elseif $item.TYPE eq 'FILE'}
							{if $data[$item.FIELD_NAME] neq ''}
								<a href="../uploads/reviews/{$data[$item.FIELD_NAME]}" target="_blank">{$data[$item.FIELD_NAME]}</a>
							{/if}
						{elseif $item.TYPE eq 'IMAGE'}
							{if $data[$item.FIELD_NAME] neq ''}
								<img src="../uploads/reviews/thumb/{$data[$item.FIELD_NAME]}"/>
							{/if}
						{/if}
						{if $item.DESCRIPTION}
							<p class="msg notice info">{$item.DESCRIPTION}</p>
						{/if}
					</td>
				</tr>
			{/if}
			{/foreach}
		</table>
	</div>
	{/if}

	{if $link_type_details.DEEP_LINKS > 0}
	<table class="formPage">
		<tbody>
		<tr>
			<td class="label required"><label>{l}Deep Links{/l}:</label></td>
			<td class="smallDesc">
				<table id="additional_links" border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="center">{l}Titles{/l}</td>
						<td align="center">{l}URLs{/l}</td>
					</tr>

					{section name=i start=0 loop=$link_type_details.DEEP_LINKS}
					<tr>
						<td><input type="text" disabled="true" name="ADD_LINK_TITLE[]" value="{$add_links[i].TITLE}" class="text" style="width: 130px;" /></td>
						<td><input type="text" disabled="true" name="ADD_LINK_URL[]"   value="{$add_links[i].URL}"   class="text" style="width: 130px;" /></td>
					</tr>
					{/section}
				</table>

				<div class="clear"></div>
			</td>
		</tr>
		</tbody>
	</table>
	{/if}


	<table class="formPage">
		<tbody>
		{if $smarty.const.REQUIRE_REGISTERED_USER}
		<tr>
			<td class="label"><label for="OWNER_ID">{l}Assign Owner{/l}:</label></td>
			<td class="smallDesc">
				{html_options options=$ActiveUsersList selected=$data.OWNER_ID name="OWNER_ID" id="OWNER_ID"}
				<p class="msg notice info">{l}Use with care!! Selected user details will overwrite link owner name, email address and id!!{/l}</p>
			</td>
		</tr>
		{/if}

		<tr>
			<td class="label required"><label for="OWNER_EMAIL_CONFIRMED">{l}Owner Email Confirmed{/l}:</label></td>
			<td class="smallDesc">
				{html_options options=$econfirm selected=$data.OWNER_EMAIL_CONFIRMED name="OWNER_EMAIL_CONFIRMED" id="OWNER_EMAIL_CONFIRMED"}
			</td>
		</tr>

		<tr>
			<td class="label required"><label for="semail">{l}Send Email On Edit{/l}:</label></td>
			<td class="smallDesc">
				<input type="checkbox" disabled="true" id="semail" name="semail" value="1" {if $semail}checked="checked"{/if} />
				<p class="msg notice info">{l}Check this to send an email to the link owner to let them know you have edited the link.{/l}</p>
			</td>
		</tr>

		<tr>
			<td class="label required"><label for="STATUS">{l}Status{/l}:</label></td>
			<td class="smallDesc">
				{html_options options=$stats selected=$data.STATUS name="STATUS" id="STATUS"}
			</td>
		</tr>

		<tr>
			<td class="label"><label for="EXPIRY_DATE">{l}Link Expires{/l}:</label></td>
			<td class="smallDesc">
				<input type="text" disabled="true" id="EXPIRY_DATE" name="EXPIRY_DATE" value="{$data.EXPIRY_DATE}" maxlength="40" class="text" />
			</td>
		</tr>

		{if $smarty.const.ENABLE_PAGERANK}
		<tr>
			<td class="label"><label for="PAGERANK">{l}Pagerank{/l}:</label></td>
			<td class="smallDesc">
            	<input type="text" id="PAGERANK" disabled="true" name="PAGERANK" value="{$data.PAGERANK}" maxlength="2" class="text" />
            	<p class="msg notice info">{l}Leave the field blank for automatic Google Pagerank calculation or give value of "-1" for no Pagerank.{/l}</p>
			</td>
		</tr>
		{/if}

		<tr>
			<td class="label"><label for="HITS">{l}Hits{/l}:</label></td>
			<td class="smallDesc">
				<input type="text" disabled="true" id="HITS" name="HITS" value="{$data.HITS}" maxlength="15" class="text" />
			</td>
		</tr>
   </tbody>

   <tfoot>
     <tr>
         <td><input type="reset" id="reset-link-submit" name="reset" value="{l}Reset{/l}" alt="{l}Reset form{/l}" title="{l}Reset form{/l}" class="button" /></td>
         <td><input type="submit" id="send-link-submit" name="save" value="{l}Save{/l}" alt="{l}Save form{/l}" title="{l}Approve review{/l}" class="button" /></td>
      </tr>
     
   </tfoot>

   </table>
   <input type="hidden" name="formSubmitted" value="1" />
   </form>
</div>
{/strip}