{* Error and confirmation messages *}
{include file="messages.tpl"}

{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/validation.tpl" form_id="edit_article_form" validators=$validators}

{strip}
{if (isset($error) and $error gt 0) or !empty($sql_error)}
   <div class="error block">
      <h2>{l}Error{/l}</h2>
      <p>{l}An error occured while saving.{/l}</p>
      {if !empty($errorMsg)}
         <p>{$errorMsg|escape}</p>
      {/if}
      {if !empty($sql_error)}
         <p>{l}The database server returned the following message:{/l}</p>
         <p>{$sql_error|escape}</p>
      {/if}
   </div>
{/if}

{if $posted}
   <div class="success block">
      {l}Article saved.{/l}
   </div>
{/if}

{if isset($AllowedFeat) and $AllowedFeat ne 1}
   <div class="error block">
      <p>{l}Maximum number of featured articles for this category exceeded!{/l}</p>
      <p>{l}Please review article preferences.{/l}</p>
   </div>
{/if}

<div class="block">
   <form method="post" action="" id="edit_article_form">
   <table class="formPage">

   {if isset($action) and ($action eq 'N' or $action eq 'E')}
   <thead>
      <tr>
         <th colspan="2">
            {if $action eq 'N'}
               {l}Create new article review{/l}
            {elseif $action eq 'E'}
               {l}Edit article review{/l}
            {/if}
         </th>
      </tr>
  </thead>
  {/if}

   <tbody>
      <tr>
         <td class="label required"><label for="TITLE">{l}Title{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="TITLE" name="TITLE" value="{$TITLE|escape|trim}" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" />
         </td>
      </tr>
      <tr>
         <td class="label"><label for="DESCRIPTION">{l}Short Description{/l}:</label></td>
         <td class="smallDesc">
            <textarea id="DESCRIPTION" name="DESCRIPTION" rows="6" cols="50" class="text" {formtool_count_chars name="DESCRIPTION" limit=$smarty.const.ARTICLE_DESCRIPTION_MAX_LENGTH alert=true}>{$DESCRIPTION|trim|escape}</textarea>
            <p class="limitDesc">{l}Limit{/l}: <input type="text" name="DESCRIPTION_limit" class="limit_field" readonly="readonly" value="{$DescriptionLimit}" /></p>
         </td>
      </tr>
            <tr>
         <td class="label"><label for="ARTICLE">{l}Article{/l}:</label></td>
         <td class="smallDesc">
             {include file=$smarty.const.ADMIN_TEMPLATE|cat:"/rte.tpl" NAME="ARTICLE" VALUE=$ARTICLE}
         </td>
      </tr>
      {if $smarty.const.REQUIRE_REGISTERED_USER_ARTICLE}
      <tr>
         <td class="label"><label for="OWNER_ID">{l}Assign Owner{/l}</label></td>
         <td class="smallDesc">
            {html_options options=$ActiveUsersList selected=$OWNER_ID name="OWNER_ID" id="OWNER_ID"}
            <p class="msg notice info">{l}Use with care!! Selected user details will overwrite article owner name, email address and id!!{/l}</p>
         </td>
      </tr>
      {/if}
      <tr>
         <td class="label"><label for="OWNER_NAME">{l}Owner Name{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="OWNER_NAME" name="OWNER_NAME" value="{$OWNER_NAME|escape|trim}" maxlength="{$smarty.const.USER_NAME_MAX_LENGTH}" class="text" />
         </td>
      </tr>
      <tr>
         <td class="label"><label for="OWNER_EMAIL">{l}Owner Email{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="OWNER_EMAIL" name="OWNER_EMAIL" value="{$OWNER_EMAIL|escape|trim}" maxlength="255" class="text" />
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="CATEGORY_ID">{l}Category{/l}:</label></td>
         <td class="smallDesc">
            {* Load category selection *}
            {include file=$smarty.const.ADMIN_TEMPLATE|cat:"/admin_category_select.tpl"}
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="FEATURED">{l}Featured{/l}:</label></td>
         <td class="smallDesc">
            <input type="checkbox" id="FEATURED" name="FEATURED" value="1"{if $FEATURED} checked="checked"{/if} />
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="STATUS">{l}Status{/l}:</label></td>
         <td class="smallDesc">
            {html_options options=$stats selected=$STATUS name="STATUS" id="STATUS"}
         </td>
      </tr>
      <tr>
         <td class="label"><label for="EXPIRY_DATE">{l}Article Expires{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="EXPIRY_DATE" name="EXPIRY_DATE" value="{$EXPIRY_DATE}" maxlength="40" class="text" />
         </td>
      </tr>

      {if $smarty.const.ENABLE_META_TAGS eq 1}
      <tr class="thead">
         <th colspan="2">{l}META tags{/l}</th>
      </tr>
      <tr class="thead">
         <th colspan="2" class="info notice">{l}Define custom META tags for detail pages. Leave blank to use default tags defined for your directory.{/l}</th>
      </tr>
      <tr>
         <td class="label">{l}META Keywords{/l}:</td>
         <td class="smallDesc">
            <input type="text" id="META_KEYWORDS" name="META_KEYWORDS" value="{$META_KEYWORDS|escape|trim}" class="text" />
            <p class="msg notice info">{l}Separate keywords by comma.{/l}</p>
         </td>
      </tr>
      <tr>
         <td class="label">{l}META Description{/l}:</td>
         <td class="smallDesc">
            <textarea id="META_DESCRIPTION" name="META_DESCRIPTION" rows="3" cols="30" class="text" wrap="yes" {formtool_count_chars name="META_DESCRIPTION" limit=$smarty.const.META_DESCRIPTION_MAX_LENGTH alert=true}>{$META_DESCRIPTION|trim|escape}</textarea>
            <p class="limitDesc">{l}Limit{/l}: <input type="text" name="META_DESCRIPTION_limit" class="limit_field" readonly="readonly" value="{$MetaDescriptionLimit}" /></p>
         </td>
      </tr>
      {/if}
   </tbody>

   <tfoot>
      <tr>
         <td><input type="reset" id="reset-article-submit" name="reset" value="{l}Reset{/l}" alt="{l}Reset form{/l}" title="{l}Reset form{/l}" class="button" /></td>
         <td><input type="submit" id="send-article-submit" name="save" value="{l}Save{/l}" alt="{l}Save form{/l}" title="{l}Approve review{/l}" class="button" /></td>
      </tr>
   </tfoot>
   </table>

   <input type="hidden" name="id" value="{$articleId}" />
   <input type="hidden" name="formSubmitted" value="1" />
   
   </form>
</div>
{/strip}