<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
require_once 'init.php';
$currentVersion = (defined ('CURRENT_VERSION') && CURRENT_VERSION > 2 ? CURRENT_VERSION : 3.0);



$url = get_url('http://www.phplinkdirectory.com/current.php?simpleversion='.round ($currentVersion), URL_CONTENT, $_SERVER['SERVER_NAME'].request_uri());
$latestVersion = (isset ($url['content']) && !empty ($url['content']) ? trim ($url['content']) : 0);


//Check if latest version could be determined
if (!isset ($url['content']) || empty ($url['content']))
{
   //Could not determine latest version
   $version = _L('Could not determine latest version.');
   $tpl->assign('update_available', 1);
}
else
{
   //Determined latest version successfully,
   //compare against current version
   if (version_compare ($latestVersion, $currentVersion) == 1)
   {
      //Update is available
      $version = _L('A new version (##VERSION##) is available.');
      $version = str_replace('##VERSION##', $latestVersion, $version);
      $tpl->assign('update_available', 1);
   }
   else
   {
      //No update available
      $version = _L('Your installation is up to date, no updates are available for your version of PHP Link Directory.');
      $tpl->assign('update_available', 0);
   }
}

//Check phpLD installation for security risks
if (!defined ('BYPASS_SECURITY_WARNINGS') || BYPASS_SECURITY_WARNINGS == 0)
{
   //Define security warnings array
   $security_warnings = array ();

   //Check if installer is still available
   $installer = 'install/index.php';
   if (is_file (INSTALL_PATH.$installer))
   {
      $installer_msg = _L('Installer is still available. This poses a major security risk, please remove ').$installer._L(' file immediately!'.
                          '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;').'<a href="http://www.phplinkdirectory.com/kb/Installer_Still_Writable_Error_Message.html" target="_blank">'._L('[more info]').'</a>';
      $security_warnings[]    = str_replace('##INSTALLER##', '<code>'.$installer.'</code>', $installer_msg);
      unset ($installer_msg, $installer);
   }

   //Check if config file is still writeable
   $config_file = 'include/config.php';
   if (is_writable (INSTALL_PATH.$config_file))
      @ chmod ($config_file, 0755);

   if (is_writable (INSTALL_PATH.$config_file))
   {
      $config_msg = _L('The configuration file is still writable by the user the webserver runs under. This poses a security risk, please drop write permissions for ').$config_file.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="http://www.phplinkdirectory.com/kb/Configuration_File_Write_Permissions.html" target="_blank">'._L('[more info]').'</a>';
      $security_warnings[]    = str_replace('##CONFIGFILE##', '<code>'.$config_file.'</code>', $config_msg);
      unset ($config_msg, $config_file);
   }

   //check quotes qnd global
   
//   $quotes = ini_get ('magic_quotes_gpc');
   $globals = ini_get('register_globals');
   
   if (!$quotes && $globals) {
      $config_msg = _L('Attention: register_globals = On' );
      $security_warnings[]    = $config_msg;
      unset ($config_msg);
   }
   
   //

   //Security check
   if (!empty ($security_warnings))
      $tpl->assign('security_warnings', $security_warnings);

   //Free memory
   unset ($security_warnings);
}

//Directory warnings
$directory_warnings = array();

//Check if category cache is available
$countCategs = $db->GetOne("SELECT COUNT(*) FROM `{$tables['category']['name']}`");
$countNoCache = $db->GetOne("SELECT COUNT(*) FROM `{$tables['category']['name']}` WHERE `CACHE_TITLE` IS NULL OR CHAR_LENGTH(CACHE_TITLE) < 1 OR `CACHE_URL` IS NULL OR CHAR_LENGTH(CACHE_URL) < 1");

if (!empty ($countNoCache) && !empty ($countCategs) && $countNoCache <= $countCategs)
{
   $warning_msg = _L('Your category cache is not complete! ').'<a href="'.DOC_ROOT.'/dir_categs.php?action=rebuild_cache" title="Start category cache building">'._L('Start').'</a>'._L(' re-building your category cache now, or use the action button found on the ').'<a href="'.DOC_ROOT.'/dir_categs.php" title="Browse categories page">'._L('categories').'</a>'._L(' page to do so.');
   $directory_warnings[]    = str_replace (array ('##START-CACHE-URL##', '##CATEGS-URL##'), array (DOC_ROOT.'/dir_categs.php?action=rebuild_cache' , DOC_ROOT.'/dir_categs.php'), $warning_msg);
}

//Directory check
if (!empty ($directory_warnings))
   $tpl->assign('directory_warnings', $directory_warnings);

//Free memory
unset ($directory_warnings, $countCategs, $countNoCache);

//Directory statistics
$stats[0] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` > '1'");
$stats[1] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '1'");
$stats[2] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['link']['name']}` WHERE `STATUS` = '0'");

$stats[3] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['comment']['name']}` WHERE `STATUS` = '2' AND `TYPE` = '1'");
$stats[4] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['comment']['name']}` WHERE `STATUS` < '2' AND `TYPE` = '1'");

$stats[5] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['article']['name']}` WHERE `STATUS` > '1'");
$stats[6] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['article']['name']}` WHERE `STATUS` = '1'");
$stats[7] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['article']['name']}` WHERE `STATUS` = '0'");

$stats[8] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['comment']['name']}` WHERE `STATUS` = '2' AND `TYPE` = '2'");
$stats[9] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['comment']['name']}` WHERE `STATUS` < '2' AND `TYPE` = '2'");

$stats[10] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['category']['name']}`");
//$stats[4] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['email']['name']}`");
//$stats[5] = $db->GetOne("SELECT COUNT(*) FROM `{$tables['email_tpl']['name']}`");

//phpLinkDirectory News
if (ENABLE_NEWS)
{
   $url = get_url("http://www.phplinkdirectory.com/news.php", URL_CONTENT);
   if ($url['status'])
   {
      $news = parse_news($url['content']);
      $tpl->assign('news', $news);
   }
}

$tpl->assign('stats', $stats);
$tpl->assign('version', $version);

$content = $tpl->fetch(ADMIN_TEMPLATE.'/index.tpl');
$tpl->assign('content', $content);

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Compress output for faster loading
if (COMPRESS_OUTPUT == 1)
   $tpl->load_filter('output', 'CompressOutput');

//Make output
echo $tpl->fetch(ADMIN_TEMPLATE.'/main.tpl');



?>