<?php 
/*#################################################################*\
|# Licence Number 0NKV-1011-132L-0118
|# -------------------------------------------------------------   #|
|# Copyright (c)2018 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 

/*
  # ################################################################################
  # Project:   PHP Link Directory
  #
  # **********************************************************************
  # Copyright (C) 2004-2013 NetCreated, Inc. (http://www.netcreated.com/)
  #
  # This software is for use only to those who have purchased a license.
  # A license must be purchased for EACH installation of the software.
  #
  # By using the software you agree to the terms:
  #
  #    - You may not redistribute, sell or otherwise share this software
  #      in whole or in part without the consent of the the ownership
  #      of PHP Link Directory. Please contact david@david-duval.com
  #      if you need more information.
  #
  #    - You agree to retain a link back to http://www.phplinkdirectory.com/
  #      on all pages of your directory if you purchased any of our "link back"
  #      versions of the software.
  #
  #
  # In some cases, license holders may be required to agree to changes
  # in the software license before receiving updates to the software.
  # **********************************************************************
  #
  # For questions, help, comments, discussion, etc., please join the
  # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
  #
  # @link           http://www.phplinkdirectory.com/
  # @copyright      2004-2013 NetCreated, Inc. (http://www.netcreated.com/)
  # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        5.1.0 Phoenix Release
  # ################################################################################
 */

$getCategTableFields = $db->MetaColumnNames($tables['category']['name'], true);
$categTableFields = array();
foreach ($getCategTableFields as $key => $field)
    $categTableFields[$field] = $field;

unset($getCategTableFields);
//Include charsets
require_once '../include/charsets.php';
if (!is_array($charsetList) || empty($charsetList)) {
    $charsetList = array('utf-8' => _L('Unicode (UTF-8)') . ' - ' . 'utf-8');
}
/* System configuration options along with descriptions, field types, etc */
$conf = array(
    #Site
    array('ID' => 'SITE_NAME',
        'NAME' => _L('Name'),
        'DESCRIPTION' => _L('Your site name.'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'STR',
        'REQUIRED' => '1'),
    array('ID' => 'SITE_URL',
        'NAME' => _L('URL'),
        'DESCRIPTION' => _L('Your site URL with the trailing slash /'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'URL',
        'REQUIRED' => '1'),
    array('ID' => 'SITE_DESC',
        'NAME' => _L('Description'),
        'DESCRIPTION' => _L('Your site description.'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'STR',
        'REQUIRED' => '1'),
    array('ID' => 'SITE_CONTACT_EMAIL',
        'NAME' => _L('Contact email'),
        'DESCRIPTION' => _L('Email address where to send contact messages'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'USE_MOBILE_SITE',
        'NAME' => _L('Enable Mobile Site'),
        'DESCRIPTION' => _L('Auto-Detect Mobile Users and load a mobile template.'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'MAINCONTENT',
        'NAME' => _L('Main Content'),
        'DESCRIPTION' => _L('The text that is displayed on the Main page.'),
        'NOTICE' => _L('Basic Html accepted if RTE is disabled.'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'CONTENT',
        'REQUIRED' => '0'),
    array('ID' => 'SUBMIT_TERMS',
        'NAME' => _L('Submission Terms'),
        'DESCRIPTION' => _L('The text that is displayed on the rules page. Link Submit pages link to this'),
        'NOTICE' => _L('Basic Html accepted if RTE is disabled.'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'TERMS',
        'REQUIRED' => '0'),
    array('ID' => 'GOOGLE_ANALYTICS',
        'NAME' => _L('Google Analytics Code'),
        'DESCRIPTION' => _L('Insert your Google Analytics code here, this code will be inserted in all pages'),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'GOOGLE_ANALYTICS',
        'REQUIRED' => '0'),
    array('ID' => 'SERVER_OFFSET_TIME',
        'NAME' => _L('Server offset time'),
        'DESCRIPTION' => str_replace(array('#SERVER_TIME#', '#OFFSET_TIME#'), array('<code>' . date('F j, Y - G:i:s', time()) . '</code>', '<code>' . date('F j, Y - G:i:s', TIMENOW) . '</code>'), _L('Select the number of hours time difference between where you are and where the server is. Current time on server is #SERVER_TIME#, current time on server using the currently saved offset is #OFFSET_TIME#.')),
        'CONFIG_GROUP' => '1',
        'TYPE' => 'LKP',
        'OPTIONS' => array('-24' => '-24', '-23' => '-23', '-22' => '-22', '-21' => '-21', '-20' => '-20',
            '-19' => '-19', '-18' => '-18', '-17' => '-17', '-16' => '-16', '-15' => '-15',
            '-14' => '-14', '-13' => '-13', '-12' => '-12', '-11' => '-11', '-10' => '-10',
            '-9' => '-9', '-8' => '-8', '-7' => '-7', '-6' => '-6', '-5' => '-5',
            '-4' => '-4', '-3' => '-3', '-2' => '-2', '-1' => '-1', '0' => '0',
            '1' => '+1', '2' => '+2', '3' => '+3', '4' => '+4', '5' => '+5',
            '6' => '+6', '7' => '+7', '8' => '+8', '9' => '+9', '10' => '+10',
            '11' => '+11', '12' => '+12', '13' => '+13', '14' => '+14', '15' => '+15',
            '16' => '+16', '17' => '+17', '18' => '+18', '19' => '+19', '20' => '+20',
            '21' => '+21', '22' => '+22', '23' => '+23', '24' => '+24'),
        'REQUIRED' => '0'),
    /* array ('ID'            => 'DATE_FORMAT'         ,
      'NAME'          => _L('Date format')          ,
      'DESCRIPTION'   => array (
      _L('Display dates formatted according to your defined format').'.',
      str_replace('##PHP_DATE##', '<a href="http://www.php.net/strftime" title="PHP strftime() function">strftime()</a>', _L('Use PHP\'s ##PHP_DATE## formatting options').'.'),
      ) ,
      'CONFIG_GROUP'  => '1'                          ,
      'TYPE'          => 'STR'                        ,
      'REQUIRED'      => '0')                         , */
    array('ID' => 'CHARSET',
        'NAME' => _L('HTTP Character Set'),
        'DESCRIPTION' => _L('Documents transmitted with HTTP that are of type text, such as text/html, text/plain, etc., can send a charset parameter in the HTTP header to specify the character encoding of the document.'),
        'NOTICE' => str_replace(array('#IANA_URL#', '#UNICODE_REASON_URL#'), array('http://www.iana.org/assignments/character-sets', 'http://www.w3.org/International/tutorials/tutorial-char-enc/#Slide0110'), _L('In theory, any character encoding that has been registered with IANA can be used, but there is no browser that understands all of them. The more widely a character encoding is used, the better the chance that a browser will understand it. A Unicode encoding such as UTF-8 is a good choice for a number of reasons.')),
        'WARNING' => _L('Make sure your template does send the correct HTTP character set header. For HTML or XHTML served as HTML, you should always use the &lt;meta&gt; tag inside &lt;head&gt;.') . '<br />' . _L('Example') . ':<br /><code>&lt;meta http-equiv="Content-Type" content="text/html;charset={$smarty.const.CHARSET}" /&gt;</code>',
        'CONFIG_GROUP' => '1',
        'TYPE' => 'LKP',
        'OPTIONS' => $charsetList,
        'REQUIRED' => '0'),
    #Directory
    array('ID' => 'DIRECTORY_TITLE',
        'NAME' => _L('Directory title'),
        'DESCRIPTION' => _L('Page title to be used on the directory pages'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'STR',
        'REQUIRED' => '1'),
    array('ID' => 'USE_COOKIES',
        'NAME' => _L('Use Cookies'),
        'DESCRIPTION' => _L('Use cookies to track the visitor\'s Link and Category clicks instead of the database. Highly recommended to use cookies on large or busy sites.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'USE_CDN',
        'NAME' => _L('Use CDN'),
        'DESCRIPTION' => _L('Use Google CDN to server up Jquery and other javascript files. This can help speed up load times as users most likely have in their browser cache.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'CATS_PER_ROW',
        'NAME' => _L('Categories columns'),
        'DESCRIPTION' => _L('Number of columns.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'CATS_COUNT',
        'NAME' => _L('Show count'),
        'DESCRIPTION' => _L('Show the number of links and subcategories next to the category name'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'CATS_PREVIEW',
        'NAME' => _L('Subcategories preview'),
        'DESCRIPTION' => _L('No. of subcategories shown on the main page for each category (0 to disable)'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'CAT_SELECTION_METHOD',
        'NAME' => _L('Category selection method'),
        'DESCRIPTION' => _L('Type of category selection to use on submit forms. This will not work with multiple categories, and will be replaced by the Regular category selection. For more than 5000 categories, we strongly recommend the "AJAX method"'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            0 => _L('Regular Selection') . ' ' . _L('(Default)'),
            1 => _L('Defined (no selection possible)'),
            2 => _L('Live category selection with AJAX')
        ),
        'REQUIRED' => '0'),
    array('ID' => 'ENABLE_PAGERANK',
        'NAME' => _L('Enable PageRank'),
        'DESCRIPTION' => _L('Enables the Google PageRank calculation functionality.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'SHOW_PAGERANK',
        'NAME' => _L('Show PageRank'),
        'DESCRIPTION' => _L('Show the Google PageRank for links.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'DEFAULT_SORT',
        'NAME' => _L('Default link sorting'),
        'DESCRIPTION' => _L('Default sorting for links on directory pages.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            'P' => _L('PageRank'),
            'H' => _L('Hits'),
            'A' => _L('Alphabetical'),
            'D' => _L('Date Added')
        ),
        'REQUIRED' => '1'),
    array('ID' => 'RECPR_NOFOLLOW',
        'NAME' => _L('No follow on broken recipr.'),
        'DESCRIPTION' => _L('Set nofollow attribute on links with broken/missing reciprocal link.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            '0' => _L('Disabled'),
            '1' => _L('If recpr. required'),
            '2' => _L('All')
        ),
        'REQUIRED' => '1'),
    array('ID' => 'LINKS_TOP',
        'NAME' => _L('Links on top pages'),
        'DESCRIPTION' => _L('Number of links on the top pages (Latest Links, Top Hits).'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'ENABLE_RSS',
        'NAME' => _L('Enable RSS'),
        'DESCRIPTION' => _L('Enable RSS feeds on directory pages'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'INTERNAL_RSS',
        'NAME' => _L('Enable Internal RSS Links'),
        'DESCRIPTION' => _L('If Yes Rss links point to details page. If No links go to the listed site.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'EMAIL_CONFIRMATION',
        'NAME' => _L('Require Email Confirmation'),
        'DESCRIPTION' => _L('Emails must be confirmed at user registration, otherwise users will not be allowed any submissions. For unregistered users, the email address supplied at submission must be confirmed before the link shows up within the directory. Link types that have the OWNER_EMAIL field disabled will be considered to have the owner email confirmed.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'SHOW_CONFIRMED_ONLY',
        'NAME' => _L('Show only links with confirmed emails on approval page'),
        'DESCRIPTION' => _L('Emails must be confirmed for the link to show on the approval page. WARNING you could possibly hide paid links awaiting approval and they end up deleted..'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'WAIT_FOR_EMAIL_CONF',
        'NAME' => _L('Wait For Email Confirmation'),
        'DESCRIPTION' => _L('Number of days to wait for before unconfirmed links are deleted.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    # Pager Mod
    array('ID' => 'PAGER_LPP',
        'NAME' => _L('Paging: Maximum per page.'),
        'DESCRIPTION' => _L('Number of links on the links pages.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'PAGER_GROUPINGS',
        'NAME' => _L('Paging: Page groupings.'),
        'DESCRIPTION' => _L('Default number of page groupings displayed.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    # Blank Window option
    array('ID' => 'ENABLE_BLANK',
        'NAME' => _L('New Windows'),
        'DESCRIPTION' => _L('Enable links to open in a new window.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    # Category sorting
    array('ID' => 'CATEG_FIELD_SORT',
        'NAME' => _L('Main categories field sort'),
        'DESCRIPTION' => _L('Choose field to sort main categories.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => $categTableFields,
        'REQUIRED' => '0'),
    array('ID' => 'CATEG_FIELD_SORT_ORDER',
        'NAME' => _L('Main categories field sort'),
        'DESCRIPTION' => _L('Choose sort order for main categories.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array('ASC' => _L('Ascending'), 'DESC' => _L('Descending')),
        'REQUIRED' => '0'),
    array('ID' => 'SUBCATEG_FIELD_SORT',
        'NAME' => _L('Subcategories field sort'),
        'DESCRIPTION' => _L('Choose field to sort subcategories.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => $categTableFields,
        'REQUIRED' => '0'),
    array('ID' => 'SUBCATEG_FIELD_SORT_ORDER',
        'NAME' => _L('Subcategories field sort'),
        'DESCRIPTION' => _L('Choose sort order for subcategories.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array('ASC' => _L('Ascending'), 'DESC' => _L('Descending')),
        'REQUIRED' => '0'),
    # Other
    array('ID' => 'SECOND_SEARCH_FIELD',
        'NAME' => _L('Show location field in search form'),
        'DESCRIPTION' => _L(''),
        'NOTICE' => _L(''),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'BOOLEAN_SEARCH_ACTIVE',
        'NAME' => _L('Boolean search'),
        'DESCRIPTION' => _L('Choose your search type. Boolean for more exact matches but usually less results, or regular search with more results but not that exact matches.'),
        'NOTICE' => _L('Works only on MySQL version 4.0.1 and above, it also needs to be activated by the server administrator.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'OPTIONS_SEARCH_FIELD',
    	'NAME' => _L('Select search form'),
    	'DESCRIPTION' => _L('Choose your search form. Basic Search, Ajax Search and  Search with Location added'),
    	'OPTIONS' => array(0 => 'Basic Search', 1 => 'Ajax Search', 2 => 'Search with Location added'),
    	'NOTICE' => _L(''),
    	'CONFIG_GROUP' => '2',
    	'TYPE' => 'LKP',
    	'REQUIRED' => '0'),
    array('ID' => 'LIMIT_HITS_TIME',
        'NAME' => _L('Limit link/category hits time range (in hours)'),
        'DESCRIPTION' => _L('Prevent multiple hits increment from a specific IP for the given time range.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'INT',
        'REQUIRED' => '0'),
    array('ID' => 'COMPRESS_OUTPUT',
        'NAME' => _L('Compress output'),
        'DESCRIPTION' => _L('Compress output for faster loading time and for bandwidth saving using the gzip program. Output compression must be supported by server and client.'),
        'WARNING' => _L('Use at your own risk, some search engines and most online tools like validators or SEO\'s cannot deal with compressed pages and errors or strange characters might show up!'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'COMPRESSION_LEVEL',
        'NAME' => _L('Compression level'),
        'DESCRIPTION' => _L('Lower compression level means less compressed output and less CPU usage, higher level means better compressed output and more CPU usage.'),
        'CONFIG_GROUP' => '2',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            0 => '0',
            1 => '1',
            2 => '2',
            3 => '3',
            4 => '4',
            5 => '5',
            6 => '6' . ' (' . _L('Default') . ')',
            7 => '7',
            8 => '8',
            9 => '9'
        ),
        'REQUIRED' => '0'),
    #Link Submit
    array('ID' => 'REQUIRE_REGISTERED_USER',
        'NAME' => _L('Require registered user'),
        'DESCRIPTION' => _L('To submit or modify, the user must be registered. ATTENTION: disabling this will automatically disable the "Require Email Confirmation" option in directory settings.'),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'GMAP_ENABLE',
        'NAME' => _L('Google Maps'),
        'DESCRIPTION' => _L('Enable Google Maps on Details Page. This applies to ALL Link Types at this time. ') . '<br>' . _L('When google maps is turned on, the address fields need to be enabled for the link types that you want to have maps show for.'),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'GMAP_KEY',
        'NAME' => _L('Google Map API Key'),
        'DESCRIPTION' => _L('You Must Register at http://code.google.com/apis/maps/signup.html! NOTE this is now legacy and left for older templates.'),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'SUBMIT_USE_RTE',
        'NAME' => _L('Front End Rich Text Editor'),
        'DESCRIPTION' => _L('Select what text editor enable to enhance front end submissions.'),
        'WARNING' => _L('USE RTE WITH EXTREME CAUTION! NOT FULLY TESTED!'),
        'OPTIONS' => array(0 => 'Standard', 'TINYMCE' => 'TinyMCE', 'YRTE' => 'Yahoo RTE', 'CKE' => 'CK Editor',),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'LKP',
        'REQUIRED' => '1'),
    array('ID' => 'DISABLE_SUBMIT',
        'NAME' => _L('Disable Link Submissions'),
        'DESCRIPTION' => _L('Turns off link submissions to your directory.'),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'DISABLE_REASON',
        'NAME' => _L('Disable Reason'),
        'DESCRIPTION' => _L('The reason that submissions are disabled.'),
        'NOTICE' => _L('Basic Html accepted if RTE is Disabled'),
        'CONFIG_GROUP' => '3',
        'TYPE' => 'DISABLE_REASON',
        'REQUIRED' => '0'),
    #Search Engine Optimization
  array('ID' => 'SEO_SHOW_LINK_TYPE',
        'NAME' => _L('Show Link Type as Folder'),
        'DESCRIPTION' => _L(''),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'SEO_URL_EXTENSION',
        'NAME' => _L('Url Extension'),
        'DESCRIPTION' => _L(''),
        'CONFIG_GROUP' => '4',
        'OPTIONS' => array('.htm' => '.htm', '.html' => '.html', '.php' => '.php', '' => 'no extension'),
        'TYPE' => 'LKP',
        'REQUIRED' => '0'),
    array('ID' => 'SEO_CATEGORY_NAME',
        'NAME' => _L('Show Category Name'),
        'DESCRIPTION' => _L(''),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),

    array('ID' => 'ENABLE_META_TAGS',
        'NAME' => _L('Enable META tags'),
        'DESCRIPTION' => _L('Enables generation of search engine friendly and descriptive URLs.'),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'DEFAULT_META_KEYWORDS',
        'NAME' => _L('Default META keywords'),
        'DESCRIPTION' => array(
            _L('This are the default META keywords used if META keywords are enabled and no keywords are found on the browsing page.'),
            _L('A META keywords tag is supposed to be a brief and concise list of the most important themes/keywords which you would like search engines to rank your site.')
        ),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'DEFAULT_META_DESCRIPTION',
        'NAME' => _L('Default META description'),
        'DESCRIPTION' => array(
            _L('This is the default META description used if META descriptions are enabled and no description is found on the browsing page.'),
            _L('A META description tag is supposed to be a brief and concise summary of your page\'s content.')
        ),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'DEFAULT_META_AUTHOR',
        'NAME' => _L('Default META author'),
        'DESCRIPTION' => _L('The author META tag defines the name of the author of the document being read.'),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'DEFAULT_META_COPYRIGHT',
        'NAME' => _L('Default META copyright'),
        'DESCRIPTION' => _L('The copyright META tag is used to include copyright information in the document.'),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'DEFAULT_META_ROBOTS',
        'NAME' => _L('Default META robots'),
        'DESCRIPTION' => array(
            _L('The Robots META tag is a simple mechanism to indicate to visiting web robots if a page should be indexed, or links on the page should be followed.'),
            _L('Options') . ': all, none, index, noindex, follow, nofollow.'
        ),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'FORCE_HTTP_STATUS_OK',
        'NAME' => _L('Force valid HTTP status 200/OK'),
        'DESCRIPTION' => _L('This option will send a forced HTTP status 200/OK header on all valid pages.'),
        'WARNING' => _L('Should be used with care only to override webserver status!'),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'FORCE_INVALID_HTTP_STATUS_OK',
        'NAME' => _L('Force invalid HTTP status 200/OK'),
        'DESCRIPTION' => _L('This option will send a forced HTTP status 200/OK header on all invalid (404/Not Found) pages.'),
        'WARNING' => array(
            _L('Should be used with care only to override webserver status!'),
            _L('Do NOT use with Google/Yahoo sitemap submissions!')
        ),
        'CONFIG_GROUP' => '4',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    #Emailer
    array('ID' => 'EMAIL_METHOD',
        'NAME' => _L('Emailer Method '),
        'DESCRIPTION' => _L('Method used to send emails.'),
        'CONFIG_GROUP' => '5',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            'mail' => _L('PHP mail function'),
            'smtp' => _L('SMTP server'),
            'sendmail' => _L('sendmail command')
        ),
        'REQUIRED' => '1'),
    array('ID' => 'EMAIL_SERVER',
        'NAME' => _L('Email server (SMTP only)'),
        'DESCRIPTION' => _L('The email server used to send emails.'),
        'CONFIG_GROUP' => '5',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'EMAIL_USER',
        'NAME' => _L('SMTP user (SMTP only)'),
        'DESCRIPTION' => _L('Only if your email server requires authentication.'),
        'CONFIG_GROUP' => '5',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'EMAIL_PASS',
        'NAME' => _L('SMTP password (SMTP only)'),
        'DESCRIPTION' => _L('Only if your email server requires authentication.'),
        'CONFIG_GROUP' => '5',
        'TYPE' => 'PAS',
        'REQUIRED' => '0'),
    array('ID' => 'EMAIL_SENDMAIL',
        'NAME' => _L('sendmail path (sendmail only)'),
        'DESCRIPTION' => _L('Path to sendmail program'),
        'CONFIG_GROUP' => '5',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    #Notifications
    array('ID' => 'NTF_SUBMIT_TPL',
        'NAME' => _L('Submit notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when the link is submitted.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_APPROVE_TPL',
        'NAME' => _L('Link approve notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when the link is approved.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_REJECT_TPL',
        'NAME' => _L('Link reject notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when the link is rejected.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_PAYMENT_TPL',
        'NAME' => _L('Link payment notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when a payment is received.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_REVIEW_SUBMIT_TPL',
        'NAME' => _L('Reviewed Submit notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when a reviewed link is submitted.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_REVIEW_APPROVE_TPL',
        'NAME' => _L('Reviewed Link approve notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when a reviewed link is approved.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_REVIEW_REJECT_TPL',
        'NAME' => _L('Rewviewed Link reject notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when a reviewed link is rejected.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_EXPIRED_TPL',
        'NAME' => _L('Expired recipr. link page.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when the reciprocal link could not be found on the reciprocal link page after validation.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '2'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_INVOICE_TPL',
        'NAME' => _L('Invoice notif.'),
        'DESCRIPTION' => _L('Email template used for notifications sent to link the owner when the link needs payment.'),
        'NOTICE' => str_replace('#URL#', DOC_ROOT . '/email_message.php', _L('You can edit the templates ') . '<a href="' . DOC_ROOT . '/email_message.php">' . _L('here') . '</a>.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '4'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_USER_DETAILS_TPL',
        'NAME' => _L('User details'),
        'DESCRIPTION' => _L('Email template used for emailing users their profile settings.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '5'",
        'REQUIRED' => '0'),
    array('ID' => 'NTF_USER_PASSWORD_TPL',
        'NAME' => _L('User password recovery'),
        'DESCRIPTION' => _L('Email template used for emailing users their password recovery details.'),
        'CONFIG_GROUP' => '6',
        'TYPE' => 'LKP',
        'OPTIONS' => "SELECT `ID`, `TITLE` FROM `{$tables['email_tpl']['name']}` WHERE `TPL_TYPE` = '6'",
        'REQUIRED' => '0'),
    #Admin
    array('ID' => 'DEBUG',
        'NAME' => _L('Enable debugging'),
        'DESCRIPTION' => _L('PHP error logs are created in ./temp folder.'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'LINKS_PER_PAGE',
        'NAME' => _L('Links per page'),
        'DESCRIPTION' => _L('The maximum number of links to be displayed on a page.'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'MAILS_PER_PAGE',
        'NAME' => _L('Emails per page'),
        'DESCRIPTION' => _L('The maximum number of Emails to be displayed on a page.'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'BYPASS_SECURITY_WARNINGS',
        'NAME' => _L('Bypass security warnings'),
        'DESCRIPTION' => _L('Do not show possible security warnings on the main page of your administrator control panel.'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'ENABLE_NEWS',
        'NAME' => _L('Enable news'),
        'DESCRIPTION' => _L('Retrieve the latest news from www.phplinkdirectory.com.'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'ADMIN_REDIRECT_TIMEOUT',
        'NAME' => _L('Redirect timeout'),
        'DESCRIPTION' => _L('Timeout of redirect messages (in seconds)'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    array('ID' => 'ADMIN_CAT_SELECTION_METHOD',
        'NAME' => _L('Category selection method'),
        'DESCRIPTION' => _L('Type of category selection to use on submit forms. This will not work with multiple categories, and will be replaced by the Regular category selection. '),
        'NOTICE' => _L('JavaScript and AJAX support must be enabled in your browser to use AJAX Live Category Selection!'),
        'CONFIG_GROUP' => '7',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            0 => _L('Regular Selection') . ' ' . _L('(Default)'),
            1 => _L('Live category selection with AJAX')
        ),
        'REQUIRED' => '0'),
    array('ID' => 'ADMIN_USE_RTE',
        'NAME' => _L('Admin Rich Text Editor'),
        'DESCRIPTION' => _L('Select what text editor enable to enhance back end submissions.'),
       'OPTIONS' => array(0 => 'Standard', 'TINYMCE' => 'TinyMCE', 'YRTE' => 'Yahoo RTE', 'CKE' => 'CK Editor',),
       'CONFIG_GROUP' => '7',
        'TYPE' => 'LKP',
        'REQUIRED' => '1'),
    array('ID' => 'FTR_MAX_LINKS',
        'NAME' => _L('Max. featured links'),
        'DESCRIPTION' => _L('The maximum number of featured links accepted per category.'),
        'CONFIG_GROUP' => '8',
        'TYPE' => 'INT',
        'REQUIRED' => '1'),
    #Payment
    /* array ('ID'            => 'PAY_ENABLE',
      'NAME'          => _L('Enable payments'),
      'DESCRIPTION'   => _L('Enables the paid links functionality.'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LOG',
      'REQUIRED'      => '1'),
     */
    /* Depreciated
      array ('ID'            => 'PAY_UM',
      'NAME'          => _L('Time unit'),
      'DESCRIPTION'   => _L('Time unit used for paid links validity period'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LKP',
      'OPTIONS'       => $payment_um,
      'REQUIRED'      => '1'),
     */
    /*
      array ('ID'            => 'PAY_NORMAL',
      'NAME'          => _L('Regular price'),
      'DESCRIPTION'   => _L('Unit price for regular links. Set to 0 if you don\'t want to require any payment for regular links'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'NUM',
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_UMN',
      'NAME'          => _L('Time unit for Regular Links '),
      'DESCRIPTION'   => _L('Time unit used for paid regular links validity period'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LKP',
      'OPTIONS'       => $payment_um,
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_FEATURED',
      'NAME'          => _L('Featured price'),
      'DESCRIPTION'   => _L('Unit price for featured links. If greater than 0 users will be able to submit featured links.'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'NUM',
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_UMF',
      'NAME'          => _L('Time unit for Featured Links'),
      'DESCRIPTION'   => _L('Time unit used for paid links validity period'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LKP',
      'OPTIONS'       => $payment_um,
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_RECPR',
      'NAME'          => _L('Recpr. price'),
      'DESCRIPTION'   => _L('Unit price for links with reciprocal link. If set to 0 links with reciprocal link will not require any payment.'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'NUM',
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_UMR',
      'NAME'          => _L('Time unit for Reciprocal Links'),
      'DESCRIPTION'   => _L('Time unit used for paid reciprocal links validity period'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LKP',
      'OPTIONS'       => $payment_um,
      'REQUIRED'      => '1'),
      array ('ID'            => 'PAY_ENABLE_FREE',
      'NAME'          => _L('Free links'),
      'DESCRIPTION'   => _L('Enables free links, but with a nofollow attribute.'),
      'CONFIG_GROUP'  => '9',
      'TYPE'          => 'LOG',
      'REQUIRED'      => '1'),
     */
    array('ID' => 'PAYPAL_ACCOUNT',
        'NAME' => _L('PayPal account'),
        'DESCRIPTION' => _L('Your PayPal account.'),
        'CONFIG_GROUP' => '9',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'PAY_CURRENCY_CODE',
        'NAME' => _L('Define currency'),
        'DESCRIPTION' => _L('Defines the currency you want to receive money.'),
        'CONFIG_GROUP' => '9',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            'USD' => "&#036; - " . _L('US Dollar'),
            'CAD' => "&#036; - " . _L('Canadian Dollar'),
            'AUD' => "&#036; - " . _L('Australian Dollar'),
            'EUR' => "&#8364; - " . _L('Euro'),
            'GBP' => "&#163; - " . _L('Pound Sterling'),
            'JPY' => "&#165; - " . _L('Japanese Yen')
        ),
        'REQUIRED' => '1'),
    array('ID' => 'PAY_ENABLE_SUBSCRIPTION',
        'NAME' => _L('Enable subscription'),
        'DESCRIPTION' => _L('Enables to automatically renew payment after validity period.'),
        'NOTICE' => array(
            _L('Subscriptions are not possible if time unit is set to: unlimited.'),
            _L('Subscriptions calculate semesters as 6 months.')
        ),
        'CONFIG_GROUP' => '9',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    #Image Verification
    array('ID' => 'VISUAL_CONFIRM',
        'NAME' => _L('Visual confirmation'),
        'DESCRIPTION' => _L('Display antispam visual confirmation code on link submit page.'),
        'CONFIG_GROUP' => '10',
        'TYPE' => 'LOG1',
        'REQUIRED' => '1'),
    array('ID' => 'CAPTCHA_DISTORTION_LEVEL',
        'NAME' => _L('Visual confirmation distort level'),
        'DESCRIPTION' => _L('Select a distortion level for the visual confirmation code.'),
        'CONFIG_GROUP' => '10',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            1 => _L('no distorsion'),
            2 => _L('low distorsion'),
            3 => _L('medium distorsion'),
            4 => _L('heavy distorsion'),
            5 => _L('extreme distorsion')
        ),
        'REQUIRED' => '0'),
    array('ID' => 'CAPTCHA_PHRASE_LENGTH',
        'NAME' => _L('Visual confirmation phrase length'),
        'DESCRIPTION' => _L('Select the phrase length for the visual confirmation.'),
        'CONFIG_GROUP' => '10',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            4 => '4',
            5 => '5',
            6 => '6',
            7 => '7'
        ),
        'REQUIRED' => '0'),
    array('ID' => 'CAPTCHA_PHRASE_TYPE',
        'NAME' => _L('Visual confirmation phrase type'),
        'DESCRIPTION' => _L('Select the phrase type for the visual confirmation.'),
        'CONFIG_GROUP' => '10',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            'alphanumeric' => _L('Alphanumeric'),
            'alphabetical' => _L('Alphabetical'),
            'numeric' => _L('Numeric')
        ),
        'REQUIRED' => '0'),
    array('ID' => 'CAPTCHA_SIMPLE',
        'NAME' => _L('Really simple image verification'),
        'DESCRIPTION' => _L('Select this option for a basic image and/or if no TTF or GD font support is enabled.'),
        'CONFIG_GROUP' => '10',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'CAPTCHA_PREVIEW',
        'NAME' => _L('Visual confirmation image preview'),
        'DESCRIPTION' => '<img src="' . DOC_ROOT . '/preview_captcha.php?level=' . (CAPTCHA_DISTORTION_LEVEL ? CAPTCHA_DISTORTION_LEVEL : 1) . '&amp;simple=' . (CAPTCHA_SIMPLE ? 1 : 0) . '" alt="' . _L('Visual Confirmation Preview') . '" title="' . _L('Visual Confirmation Preview') . '" class="captcha" />',
        'CONFIG_GROUP' => '10',
        'REQUIRED' => '0'),
    #Form Fields
    array('ID' => 'USER_LOGIN_MIN_LENGTH',
        'NAME' => _L('Minimum Loginname Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a valid loginname, for the purpose of ensuring that new members create valid loginnames.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'USER_LOGIN_MAX_LENGTH',
        'NAME' => _L('Maximum Loginname Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a valid loginname, for the purpose of ensuring that new members create valid loginnames.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'USER_NAME_MIN_LENGTH',
        'NAME' => _L('Minimum Username Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a valid username, for the purpose of ensuring that new members create valid usernames.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'USER_NAME_MAX_LENGTH',
        'NAME' => _L('Maximum Username Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a valid username, for the purpose of ensuring that new members create valid usernames.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'USER_PASSWORD_MIN_LENGTH',
        'NAME' => _L('Minimum Password Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a valid password, for the purpose of ensuring that new members create valid password.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'USER_PASSWORD_MAX_LENGTH',
        'NAME' => _L('Maximum Password Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a valid password, for the purpose of ensuring that new members create valid password.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'TITLE_MIN_LENGTH',
        'NAME' => _L('Minimum Link Title Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a title, for the purpose of ensuring that members create valid link titles.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'TITLE_MAX_LENGTH',
        'NAME' => _L('Maximum Link Title Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a title, for the purpose of ensuring that members create valid link titles.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'DESCRIPTION_MIN_LENGTH',
        'NAME' => _L('Minimum Link Description Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a description, for the purpose of ensuring that members create valid link descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'DESCRIPTION_MAX_LENGTH',
        'NAME' => _L('Maximum Link Description Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a description, for the purpose of ensuring that members create valid link descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'CAT_TITLE_MIN_LENGTH',
        'NAME' => _L('Minimum Category Title Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a title, for the purpose of ensuring that members create valid category titles.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'CAT_TITLE_MAX_LENGTH',
        'NAME' => _L('Maximum Category Title Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a title, for the purpose of ensuring that members create valid category titles.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'CAT_DESCRIPTION_MIN_LENGTH',
        'NAME' => _L('Minimum Category Description Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a description, for the purpose of ensuring that members create valid category descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'CAT_DESCRIPTION_MAX_LENGTH',
        'NAME' => _L('Maximum Category Description Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a description, for the purpose of ensuring that members create valid category descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'META_KEYWORDS_MIN_LENGTH',
        'NAME' => _L('Minimum META Keywords Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters for META keywords, for the purpose of ensuring that members create valid keywords.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'META_KEYWORDS_MAX_LENGTH',
        'NAME' => _L('Maximum META Keywords Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters for META keywords, for the purpose of ensuring that members create valid keywords.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'META_DESCRIPTION_MIN_LENGTH',
        'NAME' => _L('Minimum META Description Length'),
        'DESCRIPTION' => _L('Enter the minimum number of characters in a META description, for the purpose of ensuring that members create valid META descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'META_DESCRIPTION_MAX_LENGTH',
        'NAME' => _L('Maximum META Description Length'),
        'DESCRIPTION' => _L('Enter the maximum number of characters in a META description, for the purpose of ensuring that members create valid META descriptions.'),
        'CONFIG_GROUP' => '11',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    # Reciprocal link setup
    array('ID' => 'RECPR_NEED_200_OK',
        'NAME' => _L('Request success status code'),
        'DESCRIPTION' => array(_L('The page where a reciprocal link is placed must return a success status code.'), _L('Success status codes are') . ': ' . _L('Informational 1xx (ie: "100 Continue")') . ' & ' . _L('Successful 2xx (ie: "200 OK")') . '.'),
        'NOTICE' => _L('Many pages return incorrect status codes even if content is complete and reciprocal link available.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'RECPR_CHECK_NOFOLLOW',
        'NAME' => _L('Check for "nofollow" attribute'),
        'DESCRIPTION' => str_replace('#NOFOLLOW#', '<code>nofollow</code>', _L('Check if reciprocal link tag has a #NOFOLLOW# attribute or if global #NOFOLLOW# link rules are set via META tags.')),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'RECPR_CHECK_DOMAIN',
        'NAME' => _L('Only domain checking'),
        'DESCRIPTION' => _L('Check if only domain is available as reciprocal link.'),
        'NOTICE' => _L('It\'s likely to match domain easier than full reciprocal link.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'SAME_DOMAIN_RECPR',
        'NAME' => _L('Same Domain for Link and Reciprocal'),
        'DESCRIPTION' => _L('Check if only submitted link and reciprocal are on the same domain.'),
        'NOTICE' => _L('This only compares the urls for the same domain.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'ENABLE_THREE_WAY',
        'NAME' => _L('Enable three-way-linking'),
        'DESCRIPTION' => _L('Submitters will have to link to a third site instead of this one.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'THREE_WAY_LINK_URL',
        'NAME' => _L('Three-way-link URL'),
        'DESCRIPTION' => _L('The URL of the site where submitters have to link.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'THREE_WAY_LINK_TITLE',
        'NAME' => _L('Three-way-link Title'),
        'DESCRIPTION' => _L('The title of the site where submitters have to link.'),
        'CONFIG_GROUP' => '12',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    # Security options
    array('ID' => 'ALLOW_HTML',
        'NAME' => _L('Allow HTML'),
        'DESCRIPTION' => _L('Allows or disallows visitors from posting HTML code in web forms.'),
        'WARNING' => _L('It is advisable to disallow your visitors from posting HTML code to prevent possible XSS attacks or layout changes!'),
        'NOTICE' => str_replace('#CLEAN_VARS#', '<code>$_REQUEST</code>, <code>$_POST</code>, <code>$_GET</code>', _L('Cleaned variables are: #CLEAN_VARS#')),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'ALLOWED_HTML_TAGS',
        'NAME' => _L('Allowed HTML tags'),
        'DESCRIPTION' => _L('HTML tags that visitors are allowed to post in your web forms.'),
        'NOTICE' => _L('Separate by comma, no spaces or other characters allowed.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'ALLOW_ATTR',
        'NAME' => _L('Allow HTML ATTRIBUTES'),
        'DESCRIPTION' => _L('Allows or disallows visitors from posting HTML ATTRIBUTES code in web forms. Examples are width, height and href (use with a)'),
        'WARNING' => _L('It is advisable to disallow your visitors from posting HTML code to prevent possible XSS attacks or layout changes!'),
        'NOTICE' => str_replace('#CLEAN_VARS#', '<code>$_REQUEST</code>, <code>$_POST</code>, <code>$_GET</code>', _L('Cleaned variables are: #CLEAN_VARS#')),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'ALLOWED_ATTR_TAGS',
        'NAME' => _L('Allowed HTML ATTRIBUTE tags'),
        'DESCRIPTION' => _L('HTML ATTRIBUTE tags that visitors are allowed to post in your web forms.'),
        'NOTICE' => _L('Separate by comma, no spaces or other characters allowed.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'FORCE_SUBMIT_SESSION',
        'NAME' => _L('Force unique submit session'),
        'DESCRIPTION' => _L('This option creates a unique session for every visitor when submit page is requested, only a perfect match of both the session and the unique hash allow the link to be saved in the database.'),
        'NOTICE' => array(_L('This option could cause some inconvenience for some visitors because strict rules have to be followed.'), _L('For extra spam protection, disallow link submission from clients that do not provide an user agent, usually these are spam bots.')),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'SECRET_SESSION_PASSWORD',
        'NAME' => _L('Secret session password'),
        'DESCRIPTION' => _L('Define a secret password that will be used to create better submit session.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
    array('ID' => 'ALLOW_EMPTY_USERAGENT',
        'NAME' => _L('Allow empty user agent'),
        'DESCRIPTION' => _L('This option allows clients with an empty user agent to submit links.'),
        'NOTICE' => array(_L('Most browsers send an user agent string, but some spam bots do not.'), _L('For extra spam protection, disallow link submission from clients that do not provide an user agent, usually these are spam bots.')),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'ALLOW_FOREIGN_REFERER',
        'NAME' => _L('Allow foreign submissions'),
        'DESCRIPTION' => array(_L('Allows or disallows submissions from other pages than yours.'), _L('It is advisable to not allow submissions from other pages.')),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'BOT_CHECK',
        'NAME' => _L('Enable checking for bots/spammers'),
        'DESCRIPTION' => _L('Checks submitters from all forms against a database of known bots and spammers.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'BOT_KEY',
        'NAME' => _L('BotScout Api Key'),
        'DESCRIPTION' => _L('You do not have to have an api key but it is advisable for busy sites.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'STR',
        'REQUIRED' => '0'),
	array('ID' => 'DISABLE_CONTACT_FORM',
        'NAME' => _L('Disable Contact Form'),
        'DESCRIPTION' => _L(' (No) Enable / (Yes) Disable Contact Form.'),
        'CONFIG_GROUP' => '13',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'), 
    #Author Info
    array('ID' => 'ALLOW_AUTHOR_INFO',
        'NAME' => _L('Use author info pages'),
        'DESCRIPTION' => _L('This will create a page for each author that will display some info about them and a website.'),
        'CONFIG_GROUP' => '18',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'ALLOW_ANONYMOUS',
        'NAME' => _L('Allow registered user anonymous status'),
        'DESCRIPTION' => _L('If registered user wishes, they may have anonymous displayed instead of their name on their links.'),
        'CONFIG_GROUP' => '18',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
//      array ('ID'            => 'ALLOW_AVATARS',
//             'NAME'          => _L('Allow authors to upload avatars'),
//             'DESCRIPTION'   => _L('Users may upload avatars to their profile. These will be displayed next to their comments. (Please make sure /images, /images/author, /images/author/thumbs are writeable.)'),
//             'CONFIG_GROUP'  => '18',
//             'TYPE'          => 'LOG',
//             'REQUIRED'      => '1'),
//
    ## Caching
    array('ID' => 'DB_CACHING',
        'NAME' => _L('Database caching'),
        'DESCRIPTION' => array(_L('Increases database efficiency by caching the results.'), _L('Caching can help the database server backend to save part or all of the work it performs so it doesn\'t have to repeat the entire sequence of steps.')),
        'NOTICE' => (!ini_get('register_globals') ? '' : str_replace('##REGISTER_GLOBALS##', '<a href="http://www.php.net/register_globals" title="PHP: register_globals">register_globals</a>', _L('For the sake of security, you have to set ##REGISTER_GLOBALS##=off in php.ini or .htaccess if you are using database caching.'))),
        'NOTICE' => ('If you enable caching and approve links or add categories then you will need to clean the cache using the clean cache now option from the cache menu. If you do not do so then the links or categories will not show until the default timeout has occurred. The information is saved to the database.'),
        'WARNING' => (isset($db_cache_dir) && is_dir($db_cache_dir) && is_writeable($db_cache_dir) ? '' : str_replace('##DB_CACHE_DIR##', '<code>' . $db_cache_dir . '</code>', _L('Dabase cache folder ##DB_CACHE_DIR## is not writeable')) . '.'),
        'CONFIG_GROUP' => '15',
        'TYPE' => 'LOG',
        'REQUIRED' => '0'),
    array('ID' => 'DB_CACHE_TIMEOUT',
        'NAME' => _L('Database cache timeout') . ' (' . _L('seconds') . ')',
        'DESCRIPTION' => array(_L('The default database cache timeout until a stored query will expire.'), str_replace('##DEFAULT_DBCACHE_TIMEOUT##', '3600', _L('Default is ##DEFAULT_DBCACHE_TIMEOUT## seconds')) . '.'),
        'CONFIG_GROUP' => '15',
        'TYPE' => 'NUM',
        'REQUIRED' => '0'),
    array('ID' => 'CRON_ADOCACHEFLUSH_HOUR',
        'NAME' => _L('Daily CRON time to flush database cache'),
        'DESCRIPTION' => array(_L('Set the time of day when a CRON job is executed to flush the comeplete database cache.'), _L('This feature is used only to keep the database cache folder clean, as it could get large on directories with high traffic.')),
        'NOTICE' => _L('Last CRON job executed') . ': ' . (empty($phpldSettings['CRON_ADOCLEARCACHE_LASTRUN']) ? _L('Never') : date('F j, Y - G:i:s', $phpldSettings['CRON_ADOCLEARCACHE_LASTRUN']) . '<br />Current time is ' . date('F j, Y - G:i:s', TIMENOW)),
        'CONFIG_GROUP' => '15',
        'TYPE' => 'LKP',
        'OPTIONS' => array(0 => 0, 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5,
            6 => 6, 7 => 7, 8 => 8, 9 => 9, 10 => 10, 11 => 11,
            12 => 12, 13 => 13, 14 => 14, 15 => 15, 16 => 16,
            17 => 17, 18 => 18, 19 => 19, 20 => 20, 21 => 21,
            22 => 22, 23 => 23, '' => _L('Disabled')
        ),
        'REQUIRED' => '0'),
	#Link Contact Listing
    array('ID' => 'CONTACT_LISTING',
        'NAME' => _L('Use link "contact listing" functionality'),
        'DESCRIPTION' => _L('Turn on/off "contact listing" functionality for links.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    #Link Tell Friend
    array('ID' => 'LINK_TELL_FRIEND',
        'NAME' => _L('Use link "tell friend" functionality'),
        'DESCRIPTION' => _L('Turn on/off "tell friend" functionality for links.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    #Link Comments
    array('ID' => 'LINK_COMMENT',
        'NAME' => _L('Use link comments'),
        'DESCRIPTION' => _L('Turn on/off comments for links.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'REQUIRE_REGISTERED_USER_LINK_COMMENT',
        'NAME' => _L('Require registered user'),
        'DESCRIPTION' => _L('To submit a comment the user must be registered'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'VISUAL_CONFIRM_LINK_COMMENTS',
        'NAME' => _L('Visual confirmation on comment submissions'),
        'DESCRIPTION' => _L('Submitter must enter visual confirmation before submission process is successful.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'AUTO_APPROVE_LINK_COMMENTS_ONOFF',
        'NAME' => _L('Auto approve comments'),
        'DESCRIPTION' => _L('Turn on/off auto approval of comments.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'AUTO_APPROVE_LINK_COMMENTS',
        'NAME' => _L('Auto approve comments amount'),
        'DESCRIPTION' => _L('Allows users to be auto approved when posting comments after this many have been approved.'),
        'CONFIG_GROUP' => '20',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    #Link Ratings
    array('ID' => 'LINK_RATING',
        'NAME' => _L('Use link ratings'),
        'DESCRIPTION' => _L('Turn on/off ratings for links.'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'LINK_MIN_RATING',
        'NAME' => _L('Minimum Rating'),
        'DESCRIPTION' => _L('Minimum rating needed to show on top links page.'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'LINK_MIN_VOTES',
        'NAME' => _L('Minimum Votes'),
        'DESCRIPTION' => _L('Minimum votes needed to show on top links page.'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'NUM',
        'REQUIRED' => '1'),
    array('ID' => 'REQUIRE_REGISTERED_USER_LINK_RATING',
        'NAME' => _L('Require registered user'),
        'DESCRIPTION' => _L('To submit a rating the user must be registered'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'LOG',
        'REQUIRED' => '1'),
    array('ID' => 'LINK_RATING_TIME',
        'NAME' => _L('Set time between ratings'),
        'DESCRIPTION' => _L('Time that must pass before same user may submit another rating.'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            86400 => _L('Day'),
            604800 => _L('Week'),
            2419200 => _L('Month'),
            29030400 => _L('Year'),
            2903040000 => _L('NEVER')
        ),
        'REQUIRED' => '1'),
    array('ID' => 'LINK_RATING_DISPLAY',
        'NAME' => _L('Display ratings as'),
        'DESCRIPTION' => _L('Set the way you want ratings to be displayed as images or numbers.'),
        'NOTICE' => _L('The image portion is still beta.'),
        'CONFIG_GROUP' => '21',
        'TYPE' => 'LKP',
        'OPTIONS' => array(
            'numeric' => _L('Numeric'),
            'image' => _L('Image'),
            'bar' => _L('Bar')
        ),
        'REQUIRED' => '1'),
);
?>