{capture name="title"} - {l}Submit Link{/l}{/capture}
{capture assign="in_page_title"}{l}Submit Link{/l}{/capture}
{capture assign="description"}{l}Submit a new link to the directory{/l}{/capture}

{include file="header.tpl"}
{include file="top_bar.tpl"}

{strip}
{if $smarty.const.DISABLE_SUBMIT == 1 && $is_admin neq 1} 
    <table width="96%" border="0" align="center" cellpadding="4" cellspacing="4" class="sp_area">   
        <tr>      
            <td>         
                <h2>{l}Closed{/l}</h2>      
           </td>   
        </tr>   
        <tr>      
            <td>         
            {l}We are sorry but link submissions are closed.{/l}<br />         {$disablereason}</a>      
            </td>   
        </tr> 
     </table> 
     <br /> 
{else}
{if ($confirmed)}
   <table border="0" class="formPage">
   <tr><td colspan="2" class="msg">
   {l}The link's email address has been confirmed.{/l}<br />
   {l}The link will be listed as soon as it is approved by a site administrator.{/l}
   </td></tr>
   </table>
{/if}
{if $smarty.const.REQUIRE_REGISTERED_USER == 1 and empty($regular_user_details.ID)}
    <table border="0" class="formPage">
       <tr>
          <td>
             <h3>{l}Information{/l}</h3>
          </td>
       </tr>
       <tr>
          <td>
             {l}You must be logged in to submit a new link.{/l}
             <br />
             {l}No account yet?{/l} <a href="{$smarty.const.DOC_ROOT}/profile.php?mode=register" title="{l}Register new user{/l}">{l}Create one{/l}</a>
          </td>
       </tr>
    </table>
{else}
    <form method="post" action="">
    <table border="0" class="formPage">
    {if $error}
       <tr><td colspan="2" class="err">
          {l}An error occured while saving the link.{/l}
       </td></tr>
    {/if}
    
    {if $double_review and !$posted}
    <tr><td colspan="2" class="err">
       {$double_review}
    </td></tr>
    {/if}
    
    {if $posted}
       <tr><td colspan="2" class="msg">
       {l}Link submitted{/l}{if $waiting_approval eq 1}{l} and awaiting approval{/l}{/if}.<br />
       {l}Submit another link.{/l}
       </td></tr>
    {/if}
    
    {if $needs_confirmation}
        <tr><td colspan="2" class="msg">
       {l}The email address you provided needs to be confirmed before the link is listed.{/l}<br />
       {l}Please check your email for the confirmation link.{/l}
       </td></tr>
    {/if}

    {if count($price) gt 0}
       {if $dont_show_pay neq 1}
           <tr><td colspan="2" class="price">
           <b>{l}Pricing{/l}:</b><br />
           <table border="0" cellspacing="10" cellpadding="0">
           {if $price.featured}
              <tr><td><input type="radio" name="LINK_TYPE" value="featured" {if $LINK_TYPE eq 'featured'}checked="true"{/if}>{l}Featured links{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.featured} - {$SubscriptionF.PERIOD} {$SubscriptionF.UM}</td></tr>
           {/if}
           {if $price.normal gt 0}
              <tr><td><input type="radio" name="LINK_TYPE" value="normal" {if $LINK_TYPE eq 'normal'}checked="true"{/if}>{l}Regular links{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.normal} - {$SubscriptionN.PERIOD} {$SubscriptionN.UM}</td></tr>
           {elseif $price.normal eq 0}
              <tr><td><input type="radio" name="LINK_TYPE" value="normal" {if $LINK_TYPE eq 'normal'}checked="true"{/if}>{l}Regular links{/l}</td><td>{l}free{/l}</td></tr>
           {/if}
           {if $ShowReciprField == 1}
             {if $price.reciprocal gt 0}
                <tr><td><input type="radio" name="LINK_TYPE" value="reciprocal" {if $LINK_TYPE eq 'reciprocal'}checked="true"{/if}>{l}Regular links with reciprocal{/l}</td><td>{$smarty.const.HTML_CURRENCY_CODE}{$price.reciprocal} - {$SubscriptionR.PERIOD} {$SubscriptionR.UM}</td></tr>
             {elseif $price.reciprocal eq 0}
                <tr><td><input type="radio" name="LINK_TYPE" value="reciprocal" {if $LINK_TYPE eq 'reciprocal'}checked="true"{/if}>{l}Regular links with reciprocal{/l}</td><td>{l}free{/l}</td></tr>
             {/if}
           {/if}
           {if isset($price.free)}
              <tr><td><input type="radio" name="LINK_TYPE" value="free" {if $LINK_TYPE eq 'free'}checked="true"{/if}>{l}Links with nofollow attribute{/l}</td><td>{l}free{/l}</td></tr>
           {/if}
           </table>
           {validate form="submit_link" id="v_LINK_TYPE" message=$smarty.capture.field_link_type}
        {/if}
        {if isset($AllowedFeat) and $AllowedFeat ne 1}
           <br /><span class="errForm">{l}No more featured links allowed for this category.{/l}</span>
        {/if}
        </td></tr>
    {/if}
{/if}

<tr>
   <td class="label underlined" align='left' colspan="2">{l}Fields marked with a {/l}<span class='req'>*</span>{l} are required.{/l}</td>
</tr>
<tr>
   <td class="label"><span class='req'>*</span>{l}Title{/l}:</td>
   <td class="field">
      <input type="text" name="TITLE" value="{$TITLE|escape|trim}" size="40" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" />
      {validate form="submit_link" id="v_TITLE" message=$smarty.capture.field_char_required}
      {if $review_link == 0 || $remove_link == 0}
         {validate form="submit_link" id="v_TITLE_U" message=$smarty.capture.title_not_unique}
      {/if}
      {validate form="submit_link" id="v_TITLE_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.TITLE_MIN_LENGTH|replace:'#MAX#':$smarty.const.TITLE_MAX_LENGTH}
   </td>
</tr>
<tr>
   <td class="label">{if $smarty.const.REQUIRE_URL}<span class='req'>*</span>{/if}{l}URL{/l}:</td>
   <td class="field">
      <input type="text" name="URL" value="{$URL|escape|trim}" size="40" maxlength="255" class="text"/>
     {if $smarty.const.REQUIRE_URL}
     {validate form="submit_link" id="v_URL" message=$smarty.capture.invalid_url}
      {validate form="submit_link" id="v_URL_ONLINE" message=$smarty.capture.url_not_online}
      {if $smarty.const.ALLOW_MULTIPLE eq 1}
         {validate form="submit_link" id="v_URL_U" message=$smarty.capture.domain_not_unique_categ}
      {else}
         {validate form="submit_link" id="v_URL_U" message=$smarty.capture.domain_not_unique}
      {/if}

      {if !$secondBanCheck}
         {validate form="submit_link" id="v_URL_BANNED" message=$smarty.capture.domain_banned}
      {else}
         {$smarty.capture.domain_banned}
      {/if}
      {/if}
 </td>
</tr>
<tr>
   <td class="label">{l}Description{/l}:</td>
   <td class="field">
   {if isset ($useRTE) and $useRTE eq 1}
   {literal}
      <script type="text/javascript">
	tinyMCE.init({
		// General options
		mode : "exact",
		elements: "DESCRIPTION",
		theme : "advanced",
		plugins : "safari,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template",

		// Theme options
		theme_advanced_buttons1 : "save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect",
		theme_advanced_buttons2 : ",fontselect,fontsizeselect,|,cut,copy,paste,pastetext,pasteword,|,outdent,indent,|,undo,redo",
		//theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid",
		//theme_advanced_buttons4 : "insertdate,inserttime,preview,|,forecolor,backcolor,|,charmap,emotions,iespell,media,advhr,|,print,|,fullscreen",
		theme_advanced_toolbar_location : "top",
		theme_advanced_toolbar_align : "left",
		theme_advanced_statusbar_location : "bottom",
		theme_advanced_resizing : true,

		// Example content CSS (should be your site CSS)
		content_css : "css/content.css"	
	
	});
    </script>
    {/literal}
    <textarea id="DESCRIPTION" name="DESCRIPTION" rows="10" cols="10" style="width: 100%">{$DESCRIPTION}
    </textarea>	
    {else}
        <textarea name="DESCRIPTION" rows="3" cols="37" class="text" {formtool_count_chars name="DESCRIPTION" limit=$smarty.const.DESCRIPTION_MAX_LENGTH alert=true}>{$DESCRIPTION|escape|trim}</textarea>
        {validate form="submit_link" id="v_DESCRIPTION_LENGTH" message=$smarty.capture.invalid_length|replace:'#MIN#':$smarty.const.DESCRIPTION_MIN_LENGTH|replace:'#MAX#':$smarty.const.DESCRIPTION_MAX_LENGTH}
        <br />
        {l}Limit{/l}: <input type="text" name="DESCRIPTION_limit" size="4" class="limit_field" readonly="readonly" value="{$DescriptionLimit|trim}" />{if isset ($allowedTags)} <small>Allowed html tags: {$allowedTags|wordwrap:30:"<br />\n"}</small>{/if} <br />{if isset ($allowedAttr)}<small>Allowed html attribute tags: {$allowedAttr|wordwrap:30:"<br />\n"}</small>{/if}
    {/if}
  </td>
</tr>
<tr>
    <td colspan="2" class="buttons">
    {if !$review_link and !$remove_link}
       <input type="submit" name="continue" value="{l}Continue{/l}" class="btn" />
    {else}
       <input type="submit" name="edit" value="{l}Continue{/l}" class="btn" />
    {/if}
    </td>
</tr>
<tr>
    <td colspan="2" class="buttons">
		<p>{l}This is a quick submit, for the fully featured submit please go{/l} <a href="{$smarty.const.DOC_ROOT}/submit.php{if !empty ($CATEGORY_ID) and $CATEGORY_ID > 0}?c={$CATEGORY_ID}{/if}" title="{l}Submit your link to the directory{/l}">{l}Here{/l}</a>.</p>
			
</table>
<input type="hidden" name="formSubmitted" value="1" />
</form>
{/if}
{include file="footer.tpl"}
{/strip}