{* Error and confirmation messages *}
{include file="messages.tpl"}

<style type="text/css" media="screen">
   	@import "{$smarty.const.TEMPLATE_ROOT}/themes/smoothness/datatable_jui.css";
   	@import "{$smarty.const.TEMPLATE_ROOT}/themes/smoothness/jquery-ui-1.7.2.custom.css";
</style>

{literal}
<script type="text/javascript">
var oTable;
jQuery(function($) {

$(document).ready(function() {

        $("#action_del").live("click", function() {
           return link_rm_confirm("{/literal}{escapejs}{l}Are you sure you want to remove this article?{/l}\n{l}Note: articles can not be restored after removal!{/l}{/escapejs}{literal}");
        });

oTable = $('#articles').dataTable( {
			"bProcessing": true,
			"bServerSide": true,
			"bJQueryUI": true,
			"bSort": true,
                        "iDisplayLength": 20,
			"sPaginationType": "full_numbers",
			"sAjaxSource": "{/literal}dir_articles_ajax.php?owner_id={$owner_id}{literal}",

			"fnRowCallback": function( nRow, aData, iDisplayIndex ) {
				var id = aData[0];
				$(nRow).attr("id",id);
				$(nRow).find("td").attr("id",id);
				
				{/literal}
				$('td:eq(1)', nRow).html(aData[1] + '<a href="{$smarty.const.DOC_ROOT}/article_details.php?id=' + id + '" title="{l}View full info of this item{/l}" id="more-info-article-' + id + '" class="more-info-article" onclick="return false;"><span>{l}More info{/l}</span></a>');
				
				if (aData[3] == '-1')
					category_html = '<span class="orphan">{l}Orphan{/l}</span>';
				else
					category_html = '<a id="category-' + aData[8] + '" href="{$smarty.const.DOC_ROOT}/article_list.php?category=' + aData[8] + '" title="{l}Browse articles of category{/l}: ' + aData[3] + '" class="category-link" onclick="return false;">' + aData[3] + '</a><a href="{$smarty.const.DOC_ROOT}/categ_details.php?id=' + aData[8] + '" title="{l}View full info of this item{/l}" id="more-info-categ-' + aData[8] + '" class="more-info-categ" onclick="return false;"><span>{l}More info{/l}</span></a>';
				
				{if $rights.editArt eq 0 && $rights.delArt eq 0}
   	  			action_edit = '<td class="noborder last-child" colspan="2">None allowed</td>';
   	  		{else}
            	{if $rights.editArt eq 1}
            		action_edit = '<a href="{$smarty.const.DOC_ROOT}/article_edit.php?action=E:' + id + '" title="{l}Edit Article{/l}: ' + aData[1] + '"><img src="{$smarty.const.TEMPLATE_ROOT}/images/pencil.png" border="0" alt="{l}Edit{/l} /></a>';
            	{/if}
            	{if $rights.delArt eq 1}
            		action_del = '<a id="action_del" href="{$smarty.const.DOC_ROOT}/article_edit.php?action=D:' + id + '"  title="{l}Remove Articles{/l}: ' + aData[1] + '"><img src="{$smarty.const.TEMPLATE_ROOT}/images/cross.png" border="0" alt="{l}Delete{/l}" /></a>';
            	{/if}
            {/if}
				{literal}
				
				$('td:eq(1) #more-info-article-' + id, nRow).click(function() {
					ajaxArticleDetailsRequest(id);
				});
				
				$('td:eq(3)', nRow).html(category_html);
				
				$('td:eq(3) #category-' + aData[8], nRow).click(function() {
					ajaxCategLinkRequest(aData[8]);
				});
				
				$('td:eq(3) #more-info-categ-' + aData[8], nRow).click(function() {
					ajaxCategDetailsRequest(aData[8]);
				});
				
				$('td:eq(7)', nRow).html(action_edit + '&nbsp;' + action_del);

				return nRow;
			}
			
		});
		
		oTable.fnSetColumnVis(8, false);

	});
	
});

</script>
{/literal}

{strip}
<div class="block">
   <!-- Action Links -->
   <ul class="page-action-list">
   	  {if $rights.addArt eq 1}
      <li><a href="{$smarty.const.DOC_ROOT}/article_edit.php?action=N" title="{l}Create new article{/l}" class="button"><span class="new-article">{l}New Article{/l}</span></a></li>
      {/if}
      {if $rights.delArt eq 1}
      {if $HaveExpiredEmail gt 0}
         <li>
            <a href="{$smarty.const.DOC_ROOT}/article_list.php?action=del_expired_emails" title="{l}Delete links with unconfirmed emails older than {/l}{$smarty.const.WAIT_FOR_EMAIL_CONF}{l} days{/l}" class="button" onclick="return link_rm_confirm('{l}Are you sure you want to remove {/l}{$HaveExpiredEmail}{l} links?{/l}\n{l}Note: links can not be restored after removal!{/l}');">
         <span class="expired-link">{l}Delete Expired{/l}</span></a></li>
      {/if}
      {/if}  
   </ul>
   <!-- /Action Links -->
   
</div>

{if $error}
<div class="block">
   <!-- Error -->
   <div class="error">
      <h2>{l}Error{/l}</h2>
      <p>{$error} {l}error(s) occured while processing.{/l}</p>
      {if !empty ($sql_error)}
         <p>{l}The database server returned the following message:{/l}</p>
         <p class="sql_error">{$sql_error}</p>
      {/if}
   </div>
   <!-- /Error -->
</div>
{/if}

<div class="block">
<table cellpadding="0" cellspacing="0" border="0" width="100%" id="articles" name="articles" class="display">
      <thead>
      <tr>
        {foreach from=$columns key=col item=name}
			<th>{$name|escape|trim}</th>
		{/foreach}
      </tr>
   </thead>

		<tbody>
			<tr>
				<td colspan="7" class="dataTables_empty">Loading data from server</td>
			</tr>
		</tbody>
	</table>
</div>

      {*include file=$smarty.const.ADMIN_TEMPLATE|cat:"/list_pager.tpl"*}
{if $rights.editArt neq 0 || $rights.delArt neq 0}
      {*include file=$smarty.const.ADMIN_TEMPLATE|cat:"/article_action_btn.tpl" linkTypeButtons="1" linkNotifButtons=$expired*}
{/if}



{/strip}