{* Error and confirmation messages *}
{include file="messages.tpl"}

{include file=$smarty.const.ADMIN_TEMPLATE|cat:"/validation.tpl" form_id="edit_article_form" validators=$validators}

{strip}
{if (isset($error) and $error gt 0) or !empty($sql_error)}
   <div class="error block">
      <h2>{l}Error{/l}</h2>
      <p>{l}An error occured while saving.{/l}</p>
      {if !empty($errorMsg)}
         <p>{$errorMsg|escape}</p>
      {/if}
      {if !empty($sql_error)}
         <p>{l}The database server returned the following message:{/l}</p>
         <p>{$sql_error|escape}</p>
      {/if}
   </div>
{/if}

{if $posted}
   <div class="success block">
      {l}Article saved.{/l}
   </div>
{/if}

<div class="block">
   <form method="post" action="" id="edit_article_form" name="edit_article_form"">
   <table class="formPage">

   <thead>
      <tr>
         <th colspan="2">
               {l}Edit Article{/l}
         </th>
      </tr>
  </thead>

   <tbody>
      <tr>
         <td class="label required"><label for="TITLE">{l}Title{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="TITLE" name="TITLE" value="{$TITLE|escape|trim}" maxlength="{$smarty.const.TITLE_MAX_LENGTH}" class="text" />
            {if $SEO_URL != ''}
            <a class="admin_action" href="{if !$smarty.const.ENABLE_REWRITE}
                                                {$smarty.const.DOC_ROOT}/article.php?id={$ID}
                                             {else}
                                                {$smarty.const.DOC_ROOT}/{$SEO_URL}{/if}" title="{l}Preview Article on the Front End{/l}" target="_blank">
            	<img src="{$smarty.const.TEMPLATE_ROOT}/images/outbox.png"/>
            </a>
            {/if}
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="DESCRIPTION">{l}Short Description{/l}:</label></td>
         <td class="smallDesc">
            <textarea id="DESCRIPTION" name="DESCRIPTION" rows="6" cols="50" class="text" {formtool_count_chars name="DESCRIPTION" limit=$smarty.const.DESCRIPTION_MAX_LENGTH alert=true}>{$DESCRIPTION|trim|escape}</textarea>
            <p class="limitDesc">{l}Limit{/l}: <input type="text" name="DESCRIPTION_limit" class="limit_field" readonly="readonly" value="{$DescriptionLimit}" /></p>
         </td>
      </tr>
      <tr>
         <td class="label"><label for="ARTICLE">{l}Article{/l}:</label></td>
         <td class="smallDesc">
            {include file=$smarty.const.ADMIN_TEMPLATE|cat:"/rte.tpl" NAME="ARTICLE" VALUE=$ARTICLE}
         </td>
      </tr>
      {if $smarty.const.REQUIRE_REGISTERED_USER_ARTICLE}
      <tr>
         <td class="label"><label for="OWNER_ID">{l}Assign Owner{/l}:</label></td>
         <td class="smallDesc">
             {html_options options=$ActiveUsersList selected=$OWNER_ID name="OWNER_ID" id="OWNER_ID"}
            <p class="msg notice info">{l}Use with care!! Selected user details will overwrite link owner name, email address and id!!{/l}</p>
         </td>
      </tr>
      {/if}
      <tr>
         <td class="label"><label for="OWNER_NAME">{l}Owner Name{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="OWNER_NAME" name="OWNER_NAME" value="{$OWNER_NAME|escape|trim}" maxlength="{$smarty.const.USER_NAME_MAX_LENGTH}" class="text" />
         </td>
      </tr>
      <tr>
         <td class="label"><label for="OWNER_EMAIL">{l}Owner Email{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="OWNER_EMAIL" name="OWNER_EMAIL" value="{$OWNER_EMAIL|escape|trim}" maxlength="255" class="text" />
         </td>
      </tr>
      <tr>
            <td class="label required"><label for="OWNER_EMAIL_CONFIRMED">{l}Owner Email Confirmed{/l}:</label></td>
            <td class="smallDesc">
                    {html_options options=$econfirm selected=$OWNER_EMAIL_CONFIRMED name="OWNER_EMAIL_CONFIRMED" id="OWNER_EMAIL_CONFIRMED"}
            </td>
      </tr>
      <tr>
         <td class="label required"><label for="CATEGORY_ID">{l}Category{/l}:</label></td>
         <td class="smallDesc">
            {* Load category selection *}
            {include file=$smarty.const.ADMIN_TEMPLATE|cat:"/admin_category_select.tpl"}
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="ARTICLE_TYPE">{l}Type Of Article{/l}:</label></td>
         <td class="smallDesc">
            {html_options options=$types selected=$ARTICLE_TYPE name="ARTICLE_TYPE" id="ARTICLE_TYPE"}
         </td>
      </tr>
      <tr>
         <td class="label required"><label for="STATUS">{l}Status{/l}:</label></td>
         <td class="smallDesc">
            {html_options options=$stats selected=$STATUS name="STATUS" id="STATUS"}
         </td>
      </tr>
      <tr>
         <td class="label"><label for="RELEASE_DATE">{l}Release Date{/l}:</label></td>
         <td class="smallDesc">
           <input id="RELEASE_DATE" type="text" name="RELEASE_DATE" value="{if $def_rel_date neq '' && $RELEASE_DATE eq ''}{$def_rel_date}{else}{$RELEASE_DATE}{/if}" class="text"/>
            <a href=""
             style="display: block; float: left; margin-left: 5px; margin-top: 1px;"  
             onclick="window.open(
             '../date_cal.html',
             'calendar',
             'toolbar=no,titlebar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=0,dependent=no,width=220,height=220');
             return false;">
             <img src="../images/date_btn.gif" border="0"></a>
         </td>
      </tr>

      {if $smarty.const.ENABLE_USER_META_TAGS_ARTICLE eq 1}
      <tr class="thead">
         <th colspan="2">{l}META tags{/l}</th>
      </tr>
      <tr class="thead">
         <td colspan="2" class="info notice">{l}Define custom META tags for detail pages. Leave blank to use default tags defined for your directory.{/l}</td>
      </tr>
      <tr>
         <td class="label"><label for="META_KEYWORDS">{l}META Keywords{/l}:</label></td>
         <td class="smallDesc">
            <input type="text" id="META_KEYWORDS" name="META_KEYWORDS" value="{$META_KEYWORDS|escape|trim}" class="text" />
            <p class="msg notice info">{l}Separate keywords by comma.{/l}</p>
         </td>
      </tr>
      <tr>
         <td class="label"><label for="META_DESCRIPTION">{l}META Description{/l}:</label></td>
         <td class="smallDesc">
            <textarea id="META_DESCRIPTION" name="META_DESCRIPTION" rows="3" cols="30" class="text" {formtool_count_chars name="META_DESCRIPTION" limit=$smarty.const.META_DESCRIPTION_MAX_LENGTH alert=true}>{$META_DESCRIPTION|trim|escape}</textarea>
            <p class="limitDesc">{l}Limit{/l}: <input type="text" name="META_DESCRIPTION_limit" class="limit_field" readonly="readonly" value="{$MetaDescriptionLimit}" /></p>
         </td>
      </tr>
      {/if}
   </tbody>

   <tfoot>
      <tr>
         <td><input type="reset" id="reset-link-submit" name="reset" value="{l}Reset{/l}" alt="{l}Reset form{/l}" title="{l}Reset form{/l}" class="button" /></td>
         <td><input type="submit" id="send-link-submit" name="save" value="{l}Save{/l}" alt="{l}Save form{/l}" title="{l}Save link{/l}" class="button" /></td>
      </tr>
   </tfoot>
   </table>
   
   <input type="hidden" name="id" value="{$ID}" />
   <input type="hidden" name="formSubmitted" value="1" />
   <input type="hidden" name="submit_session" value="{$submit_session}" />
   
   </form>
</div>
{/strip}
