<?php 
/*#################################################################*\
|# Licence Number 0H6R-0808-0UVQ-0111
|# -------------------------------------------------------------   #|
|# Copyright (c)2012 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 
	
/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2012 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        4.2.1
 # ################################################################################
 */
 
require_once 'init.php';

$current_template_path = (defined ('TEMPLATE') && TEMPLATE != '' ? TEMPLATE : 'Default');



$available_templates   = get_templates('../templates/');

$current_template      = array ();
foreach ($available_templates as $key => $template)
{
   if (strtolower ($current_template_path) == strtolower ($template['theme_path']))
   {
      $current_template = $template;
      unset ($available_templates[$key], $template);
   }
}
unset ($available_templates);

if ($_REQUEST['action'] == 'edit' && !empty ($_REQUEST['filename']))
{
   if (strchr($_REQUEST['filename'], "/")) {
       $filename = trim(substr($_REQUEST['filename'], strrpos($_REQUEST['filename'], '/') + 1));
   } else {
       $filename = trim($_REQUEST['filename']);
   }
   
   $tpl->assign('file_name', $filename);
   
   $extension = substr($filename, strrpos($filename, '.') + 1);
   
   if ($extension == "css") {
       $subpath = "style/";
   } else {
       $subpath = "";
   }
   
   $file_path = INSTALL_PATH.'templates/' . $current_template_path . '/' . $subpath . $filename;
   
   $_REQUEST['file_content'] = (!empty ($_REQUEST['file_content']) ? $_REQUEST['file_content'] : filecontent($file_path));

   if ($_REQUEST['submit'] == 'Save')
   {
      
      if ($extension != "css" && $extension != "tpl") {
          $file_saved = false;
      } else {
          if (!write_to_file($file_path, $_REQUEST['file_content']))
             $file_saved = false;
          else
          {
             //Clear the entire cache
             $tpl->clear_all_cache();
    
             //Clear all compiled template files
             $tpl->clear_compiled_tpl();
    
             $file_saved = true;
          }
      }
      $tpl->assign('file_saved', $file_saved);

      //Redirecting
      $url       = DOC_ROOT."/conf_templates_edit.php?";
      $title_msg = (!$file_saved ? _L('An error occured while saving.') : _L('File saved'));
      $status    = (!$file_saved ? 0 : 1);

      if ($status == 0)
         $url .= 'r=1&file_saved='.$status;
      else
         $url .= 'file_saved='.$status.'&action=edit&filename='. trim ($_REQUEST['filename']);

      $redirect  = javascript_redirect($url, ADMIN_REDIRECT_TIMEOUT, $title_msg, '', $status);
      $tpl->assign('redirect', $redirect);
   }
   $tpl->assign('edit_screen', true);
}
else
{
   $css_files = get_template_files(INSTALL_PATH.'templates/'.$current_template_path.'/style/', 'css');
   $tpl_files = get_template_files(INSTALL_PATH.'templates/'.$current_template_path.'/', 'css,tpl');
   $template_files = array_merge ($css_files, $tpl_files);
   //Free memory
   unset ($css_files, $tpl_files);
}

function get_template_files($dirname=INSTALL_PATH, $extension="css,tpl")
{
   $extension = str_replace (" ", "", $extension);
   $ext = explode (",", $extension);
   $output = array ();
   if ($handle = @ opendir ($dirname)) {
      while (false !== ($file = @ readdir ($handle)))
         for ($i = 0; $i < sizeof ($ext); $i++)
            if (strstr ($file, ".".$ext[$i]) && !empty ($ext[$i]) && strpos ($file, "~") === false)
                $output[] = array ('name' => $file, 'path' => $dirname.$file, 'permission' => file_status($dirname.$file));
      @ closedir ($handle);
   }
   unset ($extension,$ext,$handle,$dirname,$file);
   return $output;
}

if (isset ($file_saved))
   $tpl->assign('file_saved', $file_saved);

if ($template_files)
   $tpl->assign('template_files', $template_files);

$tpl->assign('current_template', $current_template);

$tpl->assign($_REQUEST);

//Check if preview thumbnails can be created
if (!extension_loaded ('gd'))
{
   //No GD library available => no preview
   $showPreview = 0;
   $thumbType = 0;
}
else
{
   if (!function_exists ('gd_info'))
   {
      //GD info cannot be gathered => no preview
      $showPreview = 0;
      $thumbType   = 0;
   }
   else
   {
      //Get GD info
      $gGdInfo = gd_info();

      if ($gGdInfo['PNG Support'] == 1)
      {
         //PNG support available [best]
         $showPreview = 1;
         $thumbType   = 3;
      }
      elseif ($gGdInfo['JPG Support'] == 1)
      {
         //JPG support available [good]
         $showPreview = 1;
         $thumbType   = 2;
      }
      elseif ($gGdInfo['GIF Create Support'] == 1)
      {
         //GIF support available [it's ok]
         $showPreview = 1;
         $thumbType   = 1;
      }
      else
      {
         //No PNG, JPG or GIF support => no preview
         $showPreview = 0;
         $thumbType   = 0;
      }
   }
}

$tpl->assign('showPreview', $showPreview);
$tpl->assign('thumbType'  , $thumbType);

$content = $tpl->fetch(ADMIN_TEMPLATE.'/conf_templates_edit.tpl');
$tpl->assign('content', $content);

//Clean whitespace
$tpl->load_filter('output', 'trimwhitespace');

//Make output
echo $tpl->fetch(ADMIN_TEMPLATE.'/main.tpl');
?>