<?php 
/*#################################################################*\
|# Licence Number 0NKV-1011-132L-0118
|# -------------------------------------------------------------   #|
|# Copyright (c)2018 PHP Link Directory.                           #|
|# http://www.phplinkdirectory.com                                 #|
\*#################################################################*/
	 

/**
 # ################################################################################
 # Project:   PHP Link Directory
 #
 # **********************************************************************
 # Copyright (C) 2004-2013 NetCreated, Inc. (http://www.netcreated.com/)
 #
 # This software is for use only to those who have purchased a license.
 # A license must be purchased for EACH installation of the software.
 #
 # By using the software you agree to the terms:
 #
 #    - You may not redistribute, sell or otherwise share this software
 #      in whole or in part without the consent of the the ownership
 #      of PHP Link Directory. Please contact david@david-duval.com
 #      if you need more information.
 #
 #    - You agree to retain a link back to http://www.phplinkdirectory.com/
 #      on all pages of your directory if you purchased any of our "link back" 
 #      versions of the software.
 #
 #
 # In some cases, license holders may be required to agree to changes
 # in the software license before receiving updates to the software.
 # **********************************************************************
 #
 # For questions, help, comments, discussion, etc., please join the
 # PHP Link Directory Forum http://www.phplinkdirectory.com/forum/
 #
 # @link           http://www.phplinkdirectory.com/
 # @copyright      2004-2013 NetCreated, Inc. (http://www.netcreated.com/)
 # @projectManager David DuVal <david@david-duval.com>
 # @package        PHPLinkDirectory
 # @version        5.1.0 Phoenix Release
 # ################################################################################
 */

require_once 'init.php';

$error   = 0;

if ($_REQUEST['type'] && $_REQUEST['type'] != '')
{
   $ltype    = ($_REQUEST['type'] < 0 ? 0 : intval ($_REQUEST['type']));
   $tpl->assign('ltype', strtoupper ($ltype));
}

//Determine columns
if (isset($ltype) && !empty($ltype)) {
	$columns = array ('ID', 'ORDER_ID', 'NAME', 'FIELD_NAME', 'IS_DETAIL', 'REQUIRED', 'STATUS' );
} else {
	$columns = array ('ID', 'ORDER_ID', 'NAME', 'FIELD_NAME', 'ACTION' );
}
$stats = array (0 => _L('Inactive'), 1 => _L('Pending'), 2 => _L('Active'));
$valid = array (0 => _L('Broken')  , 1 => _L('Unknown'), 2 => _L('Ok'),);
$yes_no = array (1 => _L('Yes'), 0 => _L('No'));

$where = '';

$links_per_page = (LINKS_PER_PAGE  && LINKS_PER_PAGE  > 0 ? intval (LINKS_PER_PAGE)  : 10);

if ( isset( $_GET['iSortCol_0'] ) ) {
	$sOrder = "ORDER BY  ";
	for ( $i=0 ; $i<mysqli_real_escape_string($db->_connectionID, $_GET['iSortingCols'] ) ; $i++ ) {
		$sOrder .= $columns[mysqli_real_escape_string($db->_connectionID, $_GET['iSortCol_'.$i] )]." ".mysqli_real_escape_string($db->_connectionID, $_GET['sSortDir_'.$i] ) .", ";
	}
	$sOrder = substr_replace( $sOrder, "", -2 );
}


/* Searching */

if ( $_GET['sSearch'] != "" ) {
	if (isset($ltype) && !empty($ltype)) {
		$search_text = mysqli_real_escape_string($db->_connectionID, $_GET['sSearch'] );
		$where .= " AND ( submit_item.NAME LIKE '%{$search_text}%' OR ".
			                	"submit_item.FIELD_NAME LIKE '%{$search_text}%') ";
	} else {
		$search_text = mysqli_real_escape_string($db->_connectionID, $_GET['sSearch'] );
		$where .= " AND ( {$tables['submit_item']['name']}.NAME LIKE '%{$search_text}%' OR ".
			                	"{$tables['submit_item']['name']}.FIELD_NAME LIKE '%{$search_text}%') ";
	}
}

$display_length = mysqli_real_escape_string($db->_connectionID,$_GET['iDisplayLength']);
$display_start = mysqli_real_escape_string($db->_connectionID,$_GET['iDisplayStart']);

$links_per_page = ($display_length > 0) ? $display_length : $links_per_page;
$current_item = ($display_start > 0) ? $display_start : '0';


//$left_join_categ = " LEFT JOIN `{$tables['category']['name']}` ON ({$tables['link']['name']}.CATEGORY_ID = {$tables['category']['name']}.ID) ";

if (isset($ltype) && !empty($ltype)) {
    $sql = "SELECT submit_item.ID, submit_item.ORDER_ID, submit_item.NAME, submit_item.FIELD_NAME,
IF(item_status.IS_DETAIL IS NULL,0,item_status.IS_DETAIL) as IS_DETAIL,
IF(item_status.REQUIRED IS NULL,0,item_status.REQUIRED) as REQUIRED,
IF(item_status.STATUS IS NULL,0,item_status.STATUS) as STATUS
FROM `{$tables['submit_item']['name']}` AS submit_item
LEFT JOIN `{$tables['submit_item_status']['name']}` AS item_status ON item_status.ITEM_ID = submit_item.ID  AND item_status.LINK_TYPE_ID = '{$ltype}'
ORDER BY submit_item.ORDER_ID ASC";

   $list = $db->GetAll($sql);

//   $list = $db->GetAll("SELECT submit_item.ID, submit_item.ORDER_ID, submit_item.NAME, submit_item.FIELD_NAME, item_status.IS_DETAIL, item_status.REQUIRED, item_status.STATUS FROM `{$tables['submit_item']['name']}` AS submit_item, `{$tables['submit_item_status']['name']}` AS item_status WHERE item_status.LINK_TYPE_ID = '{$ltype}' AND item_status.ITEM_ID = submit_item.ID {$where} ORDER BY submit_item.ORDER_ID ASC");
   $list_total = count($list);
   
//   $sql = "SELECT SQL_CALC_FOUND_ROWS submit_item.ID, submit_item.NAME, submit_item.FIELD_NAME, item_status.IS_DETAIL, item_status.REQUIRED, item_status.STATUS  FROM `{$tables['submit_item']['name']}` AS submit_item, `{$tables['submit_item_status']['name']}` AS item_status WHERE item_status.LINK_TYPE_ID = '{$ltype}' AND item_status.ITEM_ID = submit_item.ID {$where}  {$sOrder}";
   $sql = "SELECT SQL_CALC_FOUND_ROWS submit_item.ID, submit_item.ORDER_ID, submit_item.NAME, submit_item.FIELD_NAME,
IF(item_status.IS_DETAIL IS NULL,0,item_status.IS_DETAIL) as IS_DETAIL,
IF(item_status.REQUIRED IS NULL,0,item_status.REQUIRED) as REQUIRED,
IF(item_status.STATUS IS NULL,0,item_status.STATUS) as STATUS
FROM `{$tables['submit_item']['name']}` AS submit_item
LEFT JOIN `{$tables['submit_item_status']['name']}` AS item_status ON item_status.ITEM_ID = submit_item.ID  AND item_status.LINK_TYPE_ID = '{$ltype}'
{$sOrder}";
//    die($sql);
   $rs = $db->SelectLimit($sql, $links_per_page, $current_item);
   $filtered_total = $db->GetOne("SELECT FOUND_ROWS()");
} else {
   $list_total = $db->GetOne("SELECT COUNT(*) FROM `{$tables['submit_item']['name']}` WHERE 1  {$where}");
   $sql = "SELECT SQL_CALC_FOUND_ROWS {$tables['submit_item']['name']}.* FROM `{$tables['submit_item']['name']}`  WHERE 1  {$where}  {$sOrder}";
   
   $rs = $db->SelectLimit($sql, $links_per_page, $current_item);
   
   $filtered_total = $db->GetOne("SELECT FOUND_ROWS()");
}
   
   if ($rs === false)
      $list = array ();
   else
      $list = $rs->GetAssoc(true);

$json = link_json($list, $columns, $list_total, $filtered_total);

echo $json;

function link_json($links, $columns, $total_count, $display_count) {
	global $db, $tables, $yes_no, $link_types, $stats;
	$data = '';
	foreach ($links as $link_id => $link) {
		// First element should be a link ID that we will set as tr id
		$data .= '["'.$link_id.'",';
		foreach ($columns as $col_id => $col_name) {
			$val = $link[$col_name];
			switch ($col_name) {
				case 'STATUS':
					$val = $stats[$val];
					break;
				case 'LINK_TYPE':
					$val = $link_types[$val];
					break;
				case 'PAGERANK':
					$val = ($val < 0) ? 'N/A' : $val;
					break; 
				case 'DATE_ADDED':
					$val = strftime("%m/%d/%y");
					break;
				case 'OWNER_EMAIL_CONFIRMED':
					$val = $yes_no[$val];
					break;
				case 'ACTION':
					//$val = "<a href=\\\"".DOC_ROOT."/dir_links_edit.php?action=E:{$link_id}\\\" title=\\\"Edit Link: {$link['TITLE']}\\\" class=\\\"edit_dt\\\"><span>Edit</span></a><a href=\\\"".DOC_ROOT."/dir_links_edit.php?action=D:{$link_id}\\\" title=\\\"Remove Link: {$link['TITLE']}\\\" class=\\\"delete_dt\\\" ><span>Delete</span></a>";
					$val = '1';					
					break;
			}
			$data .= ($col_name != 'ID') ? '"'.stripStrForDT($val).'",' : '';
		}
		$data = substr($data, 0, -1);
		$data .= '],';
	}
	$data = substr($data, 0, -1);
	$result = '{
    							"sEcho": '.intval($_GET['sEcho']).',
    							"iTotalRecords": '.$total_count.',
    							"iTotalDisplayRecords": '.$display_count.',
    							"aaData": [
    											'.$data.'
    							]
    						}';
    						
    return $result;
}
?>